<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : languages/english/functions.php
	# Description: This files's format style for language.
	# Write by: Le Hung
	# Start time: October 08, 2007
	# Last update: December 26, 2007
	*/

	defined ('_SITE_START') or die ('Direct Access to this location is not allowed.');

	//vn_date_time: convert from yyyy-mm-dd H:m:s to mm-dd-yyyy H:m:s
	function format_date($date)
	{
		
		if ($date)
		{ 
			$time="";
			if (strstr($date, " ") != "") 
				list($date_only, $time)=array_pad(explode("[' ']", $date, 2), 2, null); //explode("[' ']", $date);
			else 
				$date_only = $date;

			list ($year, $month, $day) = array_pad(explode("[/.-]", $date_only, 3), 3, null); //explode ("[/.-]", $date_only);
			
			if ($time!="") 
				return date("m-d-Y", mktime(0, 0, 0, $month, $day, $year))." ".$time;
			else 
				return date("m-d-Y", mktime(0, 0, 0, floatval($month), floatval($day), floatval($year)));
		}//end if
		return false;
	}//end function

	function show_date($date)
	{
		if (!$date) return false;

		list ($year, $month, $day) = explode ("[/.-]", $date."[/.-]");
		return $month."-".$day."-".$year;
	}//end function

	function db_date($date)
	{

		if (!$date) return false;
		 
		list ($month, $day, $year) = explode ("-", $date);
		return $year."-".$month."-".$day;
	}//end function

	function show_number($number)
	{
		if (!$number) return false;
		$format_number = number_format($number);
		return $format_number;
	}//end function

	function db_number($number)
	{
		if (!$number) return false;
		$number = explode(',', $number);
		return implode('', $number);
	}//end function
?>