<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : includes/functions.php
	# Description: This file's common use all the administration tool,
				   it's to include function, using any where on the features
				   of the administrattion tool.
	# Write by: Le Hung
	# Start time: Septmber, 13 2007
	# Last update: Septmber, 13 2007
	*/

	defined ('_SITE_START') or die ('Direct Access to this location is not allowed.');

	/*Copy the named array content into the object as properties only existing properties of object are filled. When undefined in hash, properties wont be deleted
		param:
			array the input array
			obj byref the object to fill of any class
	*/
	function bind_array_to_object($array, &$obj, $ignore='', $prefix=NULL, $check_slashes=true ) 
	{
		if (!is_array($array) || !is_object($obj)) return false;

		foreach (get_object_vars($obj) as $k => $v) 
		{
			if (substr($k, 0, 1) != '_') 
			{
				if (strpos($ignore, $k) === false) 
				{
					if ($prefix) $ak = $prefix.$k;
					else $ak = $k;

					if (isset($array[$ak])) $obj->$k = ($check_slashes && get_magic_quotes_gpc())?strip_slashes($array[$k]):$array[$k];
				}//end if
			}//end if
		}//end foreach
		return true;
	}//end function

	/*Strip slashes from strings or arrays of strings
		param:
			value the input string or array
	*/
	function strip_slashes(&$value)
	{
		$ret = '';
		if (is_string($value)) 
		{
			$ret = stripslashes($value);
		}else{
			if (is_array($value)) 
			{
				$ret = array();
				while (list($key,$val) = each($value)) 
				{
					$ret[$key] = strip_slashes($val);
				}//end while
			}else{
				$ret = $value;
			}//end if
		}//end if
		return $ret;
	} //end function

	/*Utility function redirect the browser location to another url. Can optionally provide a message.
		param:
			string the file system path
			string a filter for the names
	*/
	function redirect($url, $msg='') 
	{
		// specific filters
		$filter = new InputFilter();
		$url = $filter->process($url);
		$msg = $filter->process($msg);

		if ($filter->badAttributeValue(array('href', $url))) 
		{
			$url = HTTP_SERVER;
		}//end if

		if (trim($msg)) 
		{
			if (strpos($url, '?')) $url .= '&msg='.urlencode($msg);
			else $url .= '?msg='.urlencode($msg);
		}//end if

		if (headers_sent()) 
		{
			echo "<script>document.location.href='$url';</script>\n";
		}else{
			@ob_end_clean(); // clear output buffer
			header("Location: $url");
		}//end if
		exit();
	}//end function

	/*
	
	*/
	function object_to_array($p_obj)
	{
		$retarray = null;
		if(is_object($p_obj))
		{
			$retarray = array();
			foreach (get_object_vars($p_obj) as $k => $v)
			{
				if(is_object($v)) $retarray[$k] = object_to_array($v);
				else $retarray[$k] = $v;
			}//end foreach
		}//end if
		return $retarray;
	}//end function


	/*
	
	*/
	function get_param(&$arr, $name, $def=null, $mask=0) 
	{
		$return = null;
		if (isset($arr[$name])) 
		{
			if (is_string($arr[$name])) 
			{
				if (!($mask&_NOTRIM)) $arr[$name] = trim($arr[$name]);
				if (!($mask&_ALLOWHTML)) $arr[$name] = strip_tags($arr[$name]);
				if (!get_magic_quotes_gpc()) $arr[$name] = addslashes($arr[$name]);
			}//end if

			return $arr[$name];
		} else {
			return $def;
		}//end if
	}//end fucntion

	// User friendly URL
	function rewite_url($string, $with_domain=false)
	{
		if (USER_FRIENDLY_URL)
		{
			// rewrite mode
			$string=str_replace("index.php","",$string);
			if (eregi("module=", $string))
			{
				$sef_string='';
				$temp=explode('\?', $string);
				$temp=explode('\&', $temp[1]);
				foreach ($temp as $key => $value) 
				{
					$sef_string .= $value.'/';
				}//end foreach
				$string = str_replace('=', '.', $sef_string);
			}//end if
		}//end if

		if($with_domain) return HTTP_SERVER.DIR_WS_ROOT.$string;
		else return DIR_WS_ROOT.$string;
	}//end function
?>