<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: 
	# Description: 
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/
	require_once(DIR_FS_CLASSES."customers.request.php");
	require_once(DIR_FS_CLASSES."orientation.php");
	require_once(DIR_FS_CLASSES."locations.php");
	require_once(DIR_FS_CLASSES."draw_html.php");
	require_once(DIR_FS_HTML."email_html.php");
	require_once (DIR_FS_CLASSES.'phpmailer.php');

	$action = trim(get_param($_REQUEST, 'action', ''));
	
	switch ($action)
	{
		case 'save':
			$body=save($db);
			break;
		
		default:
			$body=show($db);
			break;
	}//end switch

	function show(&$db, $error='')
	{
		global $dir_ws_theme, $tpl_path;
		$selectbox=new locations($db);
	
		$country=$selectbox->draw_popup('country_id', 'id', 'name', '', 'class="selectbox" size=1 id="country_id"', SELECT_COUNTRY, 'AND `parent_id`=0');

		$tpl=new tq_smarty();
		$tpl->assign('path_language', DIR_FS_CONFIG);
		$tpl->assign('access', $_SESSION['access']);
		$tpl->assign('dir_ws_theme', $dir_ws_theme);
		$tpl->assign('country', $country);
		$tpl->assign('dir_ws_language', DIR_WS_LANGUAGE);
		$tpl->assign('dir_ws_js', DIR_WS_JS);
		$tpl->assign('request_from', REQUEST_FORM);
		$tpl->assign('form_name', ORIENTATION);
		if ($error)
		{
			$draw_html = new draw_html($error, $dir_ws_theme);
			$tpl->assign('error', $draw_html->draw_error_form());
		}//end if
		$body=$tpl->fetch($tpl_path.'/orientation.html');
		return $body;
	}//end function

	function save(&$db)
	{
		global $config;
		$customer=new customers_request($db);
		$orientation = new form_orientation($db);
			
		$error=false;
		$ignore=null;

		$request_date = date("Y-m-d H:m:s");	
		if (!$customer->bind($_POST, $ignore)) $error=$customer->get_error(); 
		$customer->request_date=$request_date;
		$customer->group_id=7;
		$customer->status=1;
		if (!$customer->check())$error=$customer->get_error();
		if(!$error)
		{
			if (!$customer->store())
			{
				$error=$customer->get_error();
			}else{
				$orientation->customer_id = $customer->id;
				if (!$orientation->bind($_POST, $ignore)) $error=$orientation->get_error(); 
				if (!$orientation->check())$error=$orientation->get_error();
				if ($_POST['date_of_last_visit']) $orientation->date_of_last_visit=db_date($_POST['date_of_last_visit']);
				$orientation->service_home_search = isset($_POST['service_home_search'])?1:0;
				$orientation->service_schooling = isset($_POST['service_schooling'])?1:0;
				$orientation->service_culture = isset($_POST['service_culture'])?1:0;
				$orientation->service_cleaning = isset($_POST['service_cleaning'])?1:0;
				$orientation->service_handyman = isset($_POST['service_handyman'])?1:0;
				$orientation->service_maid = isset($_POST['service_maid'])?1:0;
				$orientation->service_banking = isset($_POST['service_banking'])?1:0;
				$orientation->service_internet = isset($_POST['service_internet'])?1:0;
				$orientation->create_date  = date("Y-m-d");	
				
				if(!$error)
					if (!$orientation->store()) $error=$orientation->get_error();
			}//end if
		}//end if
		
		if ($error)
		{
			$body=show($db, $error);
			return $body;
		}else{
			$header_email1=header_email_webmaster($config->person, ORIENTATION);
			$header_email2=header_email($_POST['customer'], ORIENTATION);
			$customer_content=customer_content($db);
			$orientation_content=orientation_content();
			$footer_email=footer_email();

			$send_webmaster=$header_email1;
			$send_webmaster.=$customer_content;
			$send_webmaster.=$orientation_content;
			$send_webmaster.=$footer_email;

			$send_customer=$header_email2;
			$send_customer.=$customer_content;
			$send_customer.=$orientation_content;
			$send_customer.=$footer_email;
			
			$customer_email =$_POST['email']; 
			$customer_email = str_replace("; ", ";", $customer_email);
			$customer_email = str_replace(" ;", ";", $customer_email);
			$customer_email = explode(";", $customer_email);
			
			for($i=0; $i<count($customer_email); $i++){
					if($customer->is_email($customer_email[$i])==0){
						unset($customer_email[$i]); 
					}	
			}
			
			$email_list = $config->email; 
			
			$email_config = str_replace("; ", ";", $config->email);
			$email_config = str_replace(" ;", ";", $config->email);
			$email_config = explode(";", $email_config);
			
			for($i=0;$i<count($email_config); $i++){
				for($j=0; $j<count($customer_email); $j++){
					$mail    = new PHPMailer();
					$mail->CharSet = 'UTF-8'; 
					$mail->IsSMTP(); 
					$mail->SMTPAuth = true; 
					$mail->From     = $customer_email[$j];
					$mail->FromName = $_POST['customer'];
					$mail->Subject = sprintf(SUBJECT, ORIENTATION, $_POST['customer']);
					$mail->MsgHTML($send_webmaster);
					$mail->AddAddress($email_config[$i], $email_list);
					@$mail->Send();
				}
			}	
			for($i=0;$i<count($customer_email);$i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject = sprintf(SUBJECT2, ORIENTATION);
				$mail->MsgHTML($send_customer);
				$mail->AddAddress($customer_email[$i], $_POST['customer']);
				@$mail->Send();
			}
			redirect("?module=contents&id=38");
		}//end if
	}//end function
?>