<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: classes/upload.php 
	# Description: 
	# Write by: Le Hung
	# Start time: November 17, 2007
	# Last update:  
	*/

	class upload
	{
		var $_source = null;
		var $_dest  = null;
		var $_prefix = null;
		var $_filename = null;

		function upload($source, $dest, $prefix, $filename)
		{
			$this->_source = $source;
			$this->_dest = $dest;
			$this->_prefix = $prefix;
			$this->_filename = $filename;
		}//end function

		function document()
		{
			if (!$this->_filename) return false;
			
			$format = array('.pdf', '.doc', '.rtf', '.txt', '.xl', '.xls', '.ppt', '.pps', '.zip', '.tar', '.rar');
			$ext = strrchr($this->_filename, '.');
			
			if (!in_array(strtolower($ext), $format)) return false;
			return true;
		}//end function
		
		function file_size()
		{
			if (!$this->_filename) return false;
			define ("FILE_LIMIT", "2097152");
			if ($this->_source["size"]>FILE_LIMIT) return false;
			return true;
		}//end function

		function clear_space()
		{
			if (!$this->_filename) return false;
			
			$new_str = '';
			$str = explode(" ", $this->_filename);
			for ($i=0, $n=count($str); $i<$n; $i++)
			{
				$new_str.=$str[$i];
			}//end for
			return $new_str;
		}//end function

		function isdir() 
		{
			return @is_dir($this->_dest);
		}//end function

		function copyfile($filename) 
		{
			$umask = umask(0113);
			copy ($this->_source['tmp_name'], $this->_dest.'/'.$filename);
			umask($umask);
		}//end function

		function upload_file() 
		{
			if (!$this->isdir()) return false;

			// Get the filetname of the uploaded file 
			$filename = $this->clear_space();
			$filename = strtolower($this->_prefix.$filename);	
			
			// Copy source file
			if ($this->copyfile($filename)) return false;
			return true;	
		}//end function
	}//end class
?>