<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : classes/database.php
	# Description: The database class is meant to simplify the task 
				   of accessing information from the website's database.
	# Write by: Le Hung
	# Start time: September, 12 2007
	# Last update: September, 13 2007
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');

	class database 
	{
		var $_sql='';			//var string internal variable to hold the query sql
		var $_err_num=0;		//var int internal variable to hold the database error number
		var $_err_msg='';		//var string internal variable to hold the database error message
		var $_tbl_prefix='';	//var string internal variable to hold the prefix used on all database tables
		var $_resource='';		//var internal variable to hold the connector resource
		var $_cursor=null;		//var internal variable to hold the last query cursor
		var $_debug=0;			//var boolean debug option
		var $_ticker=0;			//var int a counter for the number of queries performed by the object instance
		var $_log=null;			//var array a log of queries

		/*Database object constructor:
			param:
				string database host, 
				string database name, 
				string username, 
				string password,
				string common prefix for all tables
		*/
		function database($host='localhost', $username, $password, $db, $tbl_prefix) 
		{
			if (!function_exists('mysql_connect')) 
			{
				echo "The function mysql_connect() not found in the server.";
				exit();
			}//end if

			if (!($this->_resource = @mysql_connect($host, $username, $password))) 
			{
				echo "Can't connection to server database with this host name, username and password.";
				exit();
			}//end if

			if (!mysql_select_db($db)) 
			{
				echo "Can't connection to database on the server.";
				exit();
			}//end if

			$this->_tbl_prefix = $tbl_prefix;
			$this->_ticker = 0;
			$this->_log = array();
		}//end function

		//param int
		function debug($level) 
		{
			$this->_debug = intval($level);
		}//end function

		//return int the error number for the most recent query
		function err_num() 
		{
			return $this->_err_num;
		}//end function

		//return string the error message for the most recent query
		function err_msg() 
		{
			return str_replace(array("\n", "'"), array("\n", "\'"), $this->_err_msg);
		}//end function

		/*get a database escaped string, return string
			param: 
				string for escape
		*/
		function escaped($string) 
		{
			return mysql_real_escape_string($string);
		}//end function

		/*get a quoted database escaped string, return string
			param:
				string for quoted
		*/
		function quote($string) 
		{
			return '\'' . mysql_real_escape_string($string) . '\'';
		}//end function

		/*Sets the SQL query string for later execution. This function replaces a string identifier $prefix with the string held is the _tbl_prefix class variable.
			param:
				string the SQL query
				string the common table prefix
		*/
		function set_query($sql, $prefix='#__') 
		{
			$this->_sql = $this->replace_prefix($sql, $prefix);
		}//end function

		//return string the current value of the internal SQL vairable
		function get_query() 
		{
			return "<pre>".htmlspecialchars($this->_sql)."</pre>";
		}//end function

		//Execute the query, return mixed a database resource if successful, FALSE if not.
		function query() 
		{
			if ($this->_debug) 
			{
				$this->_ticker++;
				$this->_log[] = $this->_sql;
			}//end if

			$this->_err_num = 0;
			$this->_err_msg = '';
			$this->_cursor = mysql_query($this->_sql, $this->_resource);
			if (!$this->_cursor) 
			{
				$this->_err_num = mysql_errno($this->_resource);
				$this->_err_msg = mysql_error($this->_resource)." SQL=$this->_sql";
				if ($this->_debug) 
				{
					trigger_error(mysql_error($this->_resource), E_USER_NOTICE);
					if (function_exists('debug_backtrace')) 
					{
						foreach (debug_backtrace() as $back) 
						{
							if (@$back['file']) echo '<br />'.$back['file'].':'.$back['line'];
						}//end foreach
					}//end if
				}//end if
				return false;
			}//end if
			return $this->_cursor;
		}//end function

		//return int the number of rows returned from the most recent query.
		function get_num_rows($cur=null) 
		{
			return mysql_num_rows($cur ? $cur : $this->_cursor);
		}//end function

		//This method loads the first field of the first row returned by the query, return the value returned in the query or null if the query failed.
		function load_result() 
		{
			if (!($cur = $this->query())) return null;

			$ret = null;
			if ($row = mysql_fetch_row($cur)) $ret = $row[0];
			mysql_free_result($cur);

			return $ret;
		}//end function

		//Load an array of single field results into an array
		function load_result_array($numinarray = 0) 
		{
			if (!($cur = $this->query())) return null;

			$array = array();
			while ($row = mysql_fetch_row($cur)) 
			{
				$array[] = $row[$numinarray];
			}//end while
			mysql_free_result($cur);
			return $array;
		}//end function

		/*This global function loads the first row of a query into an object. If an object is passed to this function, the returned row is bound to the existing elements of <var>object</var>. If <var>object</var> has a value of null, then all of the returned query fields returned in the object.
			param:
				string the SQL query,
				object the address of variable
		*/
		function load_object(&$object) 
		{
			if ($object != null) 
			{
				if (!($cur = $this->query())) return false;
				
				if ($array = mysql_fetch_assoc($cur)) 
				{
					mysql_free_result($cur);
					bind_array_to_object($array, $object, null, null, false);
					return true;
				}else{
					return false;
				}//end if
			}else{
				if ($cur = $this->query()) 
				{
					if ($object = mysql_fetch_object($cur)) 
					{
						mysql_free_result($cur);
						return true;
					}else{
						$object = null;
						return false;
					}//end if
				}else{
					return false;
				}//end if
			}//end if
		}//end function

		/*Load a list of database objects, return array if key is empty as sequential list of returned records, if key is not empty then the returned array is indexed by the value the database key.  Returns null if the query fails.
			param:
				string the field name of a primary key
		*/
		function load_object_list($key='') 
		{
			if (!($cur = $this->query())) return null;

			$array = array();
			while ($row = mysql_fetch_object($cur)) 
			{
				if ($key) $array[$row->$key] = $row;
				else $array[] = $row;
			}//end while

			mysql_free_result($cur);
			return $array;
		}//end function

		//return the first row of the query.
		function load_record() 
		{
			if (!($cur = $this->query())) return null;

			$ret = null;
			//if ($row = mysql_fetch_row($cur)) $ret = $row;
			if ($row = mysql_fetch_assoc($cur)) $ret = $row;
			mysql_free_result($cur);
			//echo '<pre>';print_r($ret);echo '</pre>';
			return $ret;
		}//end function

		/*Load a list of database rows (numeric column indexing), return array if key is empty as sequential list of returned records, if key is not empty then the returned array is indexed by the value the database key.  Returns null if the query fails.
			param:
				string the field name of a primary key
		*/
		function load_record_list($key='') 
		{
			if (!($cur = $this->query())) return null;

			$array = array();
			while ($row = mysql_fetch_array($cur)) 
			{
				if ($key) $array[$row[$key]] = $row;
				else $array[] = $row;
			}//end while

			mysql_free_result($cur);
			return $array;
		}//end function

		/*Insert a record in to the database
			param:
				[type] $key_name,
				[type] $verbose
		*/
		function insert_record($table, &$object, $key_name = NULL, $verbose=false) 
		{
			$sql = "INSERT INTO $table ( %s ) VALUES ( %s ) ";
			$fields = array();
			foreach (get_object_vars($object) as $k => $v) 
			{
				if (is_array($v) or is_object($v) or $v === NULL) continue;

				if ($k[0] == '_') continue;

				$fields[] = "`$k`";
				$values[] = "'" . $this->escaped($v) . "'";
			}//end froreach

			$this->set_query(sprintf($sql, implode(",", $fields), implode(",", $values)));
			//echo $this->get_query(); 
			($verbose) && print "$sql<br />\n";

			if (!$this->query()) return false;

			$id = mysql_insert_id();
			($verbose) && print "id=[$id]<br />\n";
			if ($key_name && $id) $object->$key_name = $id;

			return true;
		}//end function

		/*Update a record exist in the database
			param:
				[type] $key_name,
				[type] $update_nulls
		*/
		function update_record($table, &$object, $key_name, $update_nulls=true) 
		{
			$sql = "UPDATE $table SET %s WHERE %s";

			$array = array();
			foreach (get_object_vars($object) as $k => $v) 
			{
				if (is_array($v) or is_object($v) or $k[0] == '_') continue;

				if ($k == $key_name) 
				{
					$where = "$key_name='" . $this->escaped($v) . "'";
					continue;
				}//end if

				if ($v === NULL && !$update_nulls) continue;

				if ($v == '') $val = "''";
				else $val = "'" . $this->escaped($v) . "'";

				$array[] = "`$k`=$val";
			}//end foreach

			 
			$this->set_query(sprintf($sql, implode(",", $array), $where));
			//echo $this->get_query();
			return $this->query();
		}//end function

		//Insert id after id final
		function insert_id()
		{
			return mysql_insert_id();
		}//end function

		//return array a list of all the tables in the database
		function get_table_list() 
		{
			$this->set_query('SHOW tables');
			$this->query();
			return $this->load_result_array();
		}//end function

		/*return array a list the create SQL for the tables
			param:	
				array a list of table names
		*/
		function create_table($tables) 
		{
			$result = array();

			foreach ($tables as $table) 
			{
				$this->set_query('SHOW CREATE table ' . $table );
				$this->query();
				$result[$table] = $this->load_result_array(1);
			}//end foreach

			return $result;
		}//end function

		/*return array an array of fields by table
			param:
				array a list of table names
		*/
		function get_table_fields($tables) 
		{
			$result = array();

			foreach ($tables as $table) 
			{
				$this->set_query('SHOW FIELDS FROM ' . $table);
				$this->query();
				$fields = $this->load_object_list();
				foreach ($fields as $field) 
				{
					$result[$table][$field->Field] = preg_replace("/[(0-9)]/",'', $field->Type);
				}//end foreach
			}//end foreach

			return $result;
		}//end function

		//get current version of MySQL on the server
		function mysql_version()
		{
			return mysql_get_server_info();
		}//end function

		/*This function replaces a string identifier $prefix with the string held is the _tbl_prefix class variable.
			param:
				string the SQL query,
				string the common table prefix
		*/
		function replace_prefix($sql, $prefix='#__') 
		{
			$sql = trim($sql);
			$escaped = false;
			$quote_char = '';
			$n = strlen($sql);
			$start_pos = 0;
			$literal = '';

			while ($start_pos < $n) 
			{
				$ip = strpos($sql, $prefix, $start_pos);
				if ($ip === false) break;

				$j = strpos($sql, "'", $start_pos);
				$k = strpos($sql, '"', $start_pos);
				if (($k !== FALSE) && (($k < $j) || ($j === FALSE))) 
				{
					$quote_char	= '"';
					$j = $k;
				}else{
					$quote_char	= "'";
				}//end if

				if ($j === false) $j = $n;

				$literal .= str_replace($prefix, $this->_tbl_prefix, substr($sql, $start_pos, $j-$start_pos));
				$start_pos = $j;
				$j = $start_pos + 1;

				if ($j >= $n) break;

				// quote comes first, find end of quote
				while (TRUE) 
				{
					$k = strpos($sql, $quote_char, $j);
					$escaped = false;
					if ($k === false) break;

					$l = $k - 1;
					while ($l >= 0 && $sql{$l} == '\\') 
					{
						$l--;
						$escaped = !$escaped;
					}//end while

					if ($escaped) 
					{
						$j	= $k+1;
						continue;
					}//end if
					break;
				}//end while

				if ($k === FALSE) break;// error in the query - no end quote; ignore it

				$literal .= substr($sql, $start_pos, $k - $start_pos + 1);
				$start_pos = $k+1;
			}//end while

			if ($start_pos < $n) 
			{
				$literal .= substr($sql, $start_pos, $n - $start_pos);
			}//end if
			return $literal;
		}//end function
	}//end class

	//access_database abstract class. It's a subpackage database. Parent classes to all database derived objects.  Customisation will generally not involve tampering with this object.
	class access_database 
	{
		var $_tbl = '';		//var string name of the table in the db schema relating to child class
		var $_tbl_key = ''; //var string name of the primary key field in the table
		var $_error = '';	//var string error message
		var $_db = null;	//var database connector

		/*Object constructor to set table and key field. Can be overloaded/supplemented by the child class
			param:
				string $table name of the table in the db schema relating to child class
				string $key name of the primary key field in the table*/
		function access_database($table, $key, &$db) 
		{
			$this->_tbl = $table;
			$this->_tbl_key = $key;
			$this->_db =&$db;
		}//end function

		/*Filters public properties, access protected.
			paran:
				array list of fields to ignore
		*/
		function filter($ignore_list=null) 
		{
			$ignore = is_array($ignore_list);
			$filter = new InputFilter();
			foreach ($this->public_properties() as $k) 
			{
				if ($ignore && in_array( $k, $ignore_list)) continue;

				$this->$k = $filter->process($this->$k);
			}//end foreach
		}//end function

		//return string the error message
		function get_error() 
		{
			return $this->_error;
		}//end function

		/*Gets the value of the class variable, return mixed the value of the class var (or null if no var of that name exists)
			param:
				string the name of the class variable
		*/
		function get($_property) 
		{
			if(isset($this->$_property)) return $this->$_property;
			else return null;
		}//end function

		//Returns an array of public properties
		function public_properties() 
		{
			static $cache = null;
			if (is_null($cache)) 
			{
				$cache = array();
				foreach (get_class_vars(get_class($this)) as $key=>$val) 
				{
					if (substr($key, 0, 1) != '_') 
					{
						$cache[] = $key;
					}//end if
				}//end foreach
			}//end if
			return $cache;
		}//end function

		/*Set the value of the class variable
			param:
				string the name of the class variable
				mixed the value to assign to the variable
		*/
		function set($_property, $_value) 
		{
			$this->$_property = $_value;
		}//end function

		/*bind a named array/hash to this object, can be overloaded/supplemented by the child class. Return null|string	null is operation was satisfactory, otherwise returns an error
			param:
				array $hash named array
		*/
		function bind($array, $ignore="") 
		{
			if (!is_array($array)) 
			{
				$this->_error = strtolower(get_class($this))."::bind failed.";
				return false;
			}else{
				return bind_array_to_object($array, $this, $ignore);
			}//end if
		}//end function

		/*return any result from the database operation
			param:
				int $oid optional argument, if not specifed then the value of current key is used
		*/
		function load($oid=null) 
		{
			$k = $this->_tbl_key;
			if ($oid !== null) $this->$k = $oid;

			$oid = $this->$k;
			if ($oid === null) return false;

			$this->_db->set_query("SELECT * FROM $this->_tbl WHERE `$this->_tbl_key`=".$oid);
			//echo $this->_db->get_query();
			return $this->_db->load_object($this);
		}//end function

		//Generic check method, can be overloaded/supplemented by the child class.return boolean True if the object is ok
		function check() 
		{
			return true;
		}//end function

		/*Inserts a new row if id is zero or updates an existing row in the database table. Can be overloaded/supplemented by the child class. Return null|string null if successful otherwise returns and error message
			param:
				boolean If false, null object variables are not updated
		*/
		function store($update_nulls=false) 
		{
			$k = $this->_tbl_key;
			global $migrate;
			if ($this->$k && !$migrate) $ret = $this->_db->update_record($this->_tbl, $this, $this->_tbl_key, $update_nulls);
			else $ret = $this->_db->insert_record($this->_tbl, $this, $this->_tbl_key);
			
			//die ($this->_db->get_query());
			if(!$ret) 
			{
				$this->_error = strtolower(get_class($this))."::store failed <br />" . $this->_db->err_msg();
				return false;
			}else{
				return true;
			}//end if
		}//end function

		function move($dirn, $where='') 
		{
			$k = $this->_tbl_key;

			$sql = "SELECT `$this->_tbl_key`, `ordering` FROM $this->_tbl";

			if ($dirn < 0) 
			{
				$sql .= "\nWHERE `ordering` < ".$this->ordering;
				$sql .= ($where ? "\n	AND $where" : '');
				$sql .= "\nORDER BY `ordering` DESC\nLIMIT 1";
			}else if ($dirn > 0){
				$sql .= "\nWHERE `ordering` > ".$this->ordering;
				$sql .= ($where ? "\n	AND $where" : '');
				$sql .= "\nORDER BY `ordering`\nLIMIT 1";
			}else{
				$sql .= "\nWHERE `ordering` = ".$this->ordering;
				$sql .= ($where ? "\n	AND $where" : '');
				$sql .= "\nORDER BY `ordering`\nLIMIT 1";
			}//end if
			$this->_db->set_query($sql);
			//die ($this->_db->get_query());

			$row = null;
			if ($this->_db->load_object($row)) 
			{
				$this->_db->set_query("UPDATE $this->_tbl SET `ordering`='$row->ordering'"
				. "\nWHERE $this->_tbl_key='".$this->$k."'"
				);
				if (!$this->_db->query()) 
				{
					$err = $this->_db->err_msg();
					die( $err );
				}//end if

				$this->_db->set_query("UPDATE $this->_tbl SET `ordering`='$this->ordering'"
				. "\nWHERE $this->_tbl_key='".$row->$k."'"
				);
				if (!$this->_db->query()) 
				{
					$err = $this->_db->err_msg();
					die( $err );
				}//end if

				$this->ordering = $row->ordering;
			}else{
				$this->_db->set_query("UPDATE $this->_tbl SET `ordering`='$this->ordering'"
				. "\nWHERE $this->_tbl_key='".$this->$k."'"
				);
				//die ($this->_db->get_query());
				if (!$this->_db->query()) 
				{
					$err = $this->_db->err_msg();
					die( $err );
				}//end if
			}//end if
		}//end function

		/*Compacts the ordering sequence of the selected records
			param:
				string additional where query to limit ordering to a particular subset of records
		*/
		function update_order($where='') 
		{
			$k = $this->_tbl_key;

			if (!array_key_exists('ordering', get_class_vars(strtolower(get_class($this))))) 
			{
				$this->_error = "WARNING: ".strtolower(get_class($this))." does not support ordering.";
				return false;
			}//end if

			$this->_db->set_query("SELECT $this->_tbl_key, `ordering` FROM $this->_tbl"
			. ($where ? "\nWHERE $where" : '')
			. "\n ORDER BY `id` ASC"
			);
			//die($this->_db->get_query());
			if (!($orders = $this->_db->load_object_list())) 
			{
				$this->_error = $this->_db->err_msg();
				return false;
			}//end if

			// first pass, compact the ordering numbers
			for ($i=0, $n=count($orders); $i < $n; $i++) 
			{
				if ($orders[$i]->ordering >= 0) 
				{
					$orders[$i]->ordering = $i+1;
				}//end if
			}//end for

			$shift = 0;
			$n=count($orders);
			for ($i=0; $i < $n; $i++) 
			{
				if ($orders[$i]->$k == $this->$k) 
				{
					$orders[$i]->ordering = min($this->ordering, $n);
					$shift = 1;
				}else if ($orders[$i]->ordering >= $this->ordering && $this->ordering > 0){
					$orders[$i]->ordering++;
				}//end if
			}//end for

			for ($i=0, $n=count( $orders ); $i < $n; $i++) 
			{
				if ($orders[$i]->ordering >= 0) 
				{
					$orders[$i]->ordering = $i+1;
					$this->_db->set_query("UPDATE $this->_tbl"
					. "\nSET `ordering`='".$orders[$i]->ordering."' WHERE $k='".$orders[$i]->$k."'"
					);
					$this->_db->query();
					//echo "<br>".$this->_db->get_query();
				}//end if
			}//end for
			//exit();

			if ($shift == 0) 
			{
				$order = $n+1;
				$this->_db->set_query("UPDATE $this->_tbl"
				. "\nSET ordering='$order' WHERE $k='".$this->$k."'"
				);
				$this->_db->query();
			}//end if

			return true;
		}//end function

		/*Generic check for whether dependancies exist for this object in the db schema, can be overloaded/supplemented by the child class. Return true|false
			param:
				string $msg error message returned
				int optional key index
				array optional array to compiles standard joins: format[label=>'Label', name=>'table name', idfield=>'field', joinfield=>'field']
		*/
		function can_delete($oid=null, $joins=null) 
		{
			$k = $this->_tbl_key;
			if ($oid) $this->$k = intval($oid);

			if (is_array($joins)) 
			{
				$select = "$this->_tbl.$k";
				$join = "";

				foreach ($joins as $table) 
				{
					$select .= ", \nCOUNT(DISTINCT {$table['name']}.{$table['idfield']}) AS {$table['idfield']}";
					$join .= " \nLEFT JOIN {$table['name']} ON {$table['name']}.{$table['joinfield']} = $this->_tbl.$k";
				}//end foreach

				$this->_db->set_query("SELECT $select\nFROM $this->_tbl\n$join\nWHERE $this->_tbl.$k = ".$this->$k." GROUP BY $this->_tbl.$k" );
				//die($this->_db->get_query());
				
				//$obj=new stdClass();
				$obj=null;
				if (!$this->_db->load_object($obj)) 
				{
					$this->_error = $this->_db->err_msg(); die($this->_error);
					return false;
				}//end if

				$msg = array();
				foreach ($joins as $table)
				{
					$k = $table['idfield'];
					//if ($obj->$k) $msg[] =  $table['label'].': '.$oid;
					if ($obj->$k) $msg[] =  $table['label'].' '.$oid;
				}//end foreach

				//print_r($msg);
				//die($this->_db->get_query());

				if (count($msg)) 
				{
					$this->_error = sprintf(CANNOT_DELETE, implode(', ', $msg), implode(', ', $msg));
					//$this->_error = "noDeleteRecord" . ": " . implode( ', ', $msg );
					return false;
				}else{
					return true;
				}//end if
			}//end if

			return true;
		}//end function

		//Default delete method, can be overloaded/supplemented by the child class. Return true if successful otherwise returns and error message
		function delete_record($oid=null) 
		{
			$k = $this->_tbl_key;
			if ($oid) $this->$k = intval($oid);

			$this->_db->set_query("DELETE FROM $this->_tbl WHERE $this->_tbl_key = '".$this->$k."'");
			
			if ($this->_db->query()) 
			{
				return true;
			}else{
				$this->_error = $this->_db->err_msg();
				return false;
			}//end if
		}//end function

		/*Generic save function. Returns TRUE if completely successful, FALSE if partially or not succesful.
			param:
				array source array for binding to class vars
				string filter for the order updating
		*/
		function save($source, $order_filter) 
		{
			if (!$this->bind($_POST)) return false;
			if (!$this->check()) return false;
			if (!$this->store()) return false;
			$filter_value = $this->$order_filter;
			$this->update_order($order_filter ? "`$order_filter`='$filter_value'" : "");
			$this->_error = '';
			return true;
		}//end function

		/*Generic Publish/Unpublish function
			param:
				an array of id numbers
				integer 0 if unpublishing, 1 if publishing
				integer the id of the user performnig the operation
		*/
		function publish_array($cid=null, $publish=1) 
		{
			if (!is_array($cid) || count($cid) < 1) 
			{
				$this->_error = "No items selected.";
				return false;
			}//end if

			$cids = implode(',', $cid);

			$this->_db->set_query("UPDATE $this->_tbl SET `active`='$publish'"
			. "\nWHERE $this->_tbl_key IN ($cids)"
			);

			if (!$this->_db->query()) 
			{
				$this->_error = $this->_db->err_msg();
				return false;
			}//end if

			return true;
		}//endfunction

		/*Export item list to xml.
			param:
				boolean map foreign keys to text values
		*/
		function item_list_to_xml($map_keys_to_text=false) 
		{
			$xml = '<record table="' . $this->_tbl . '"';
			if ($map_keys_to_text) 
			{
				$xml .= ' mapkeystotext="true"';
			}//end if
			$xml .= '>';

			foreach (get_object_vars($this) as $k => $v) 
			{
				if (is_array($v) or is_object($v) or $v === NULL) continue;

				if ($k[0] == '_') continue;

				$xml .= '<' . $k . '><![CDATA[' . $v . ']]></' . $k . '>';
			}//end foreach
			$xml .= '</record>';

			return $xml;
		}//and function
	}//end class
?>