<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/type.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: December 26, 2007
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/type.php");
	require_once("../languages/".$_SESSION['folder']."/type.php");
	require_once("./type.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$type_id = intval(get_param($_REQUEST, 'type_id', 0));

	header_page(MN_FEATURE_AREAS, MN_HOME_SEARCH.' :: '.MN_TYPE);

	$error=null;
	if (($action=='editconvert') && (!$id[0]))
	{
	 	$action='';
		$error= CONVERT_ERROR;
	}//end if

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;

		case "convert":
			if (!$type_id) $type_id=$id[0];
			convert($db, $type_id, 0);
			break;

		case "editconvert":
			convert($db, $type_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		case "saveorder":
			saveordering($db, $language_id, $id);
			break;
		
		case "orderup":
			move($db, $language_id, -1, $id[0]);
			break;
		
		case "orderdown":
			move($db, $language_id, 1, $id[0]);
			break;
		
		default:
			show($db, $language_id, $error);
			break;
	}//end switch

	function show(&$db, $language_id, $error='')
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='tc.*, t.`id` AS `id_default`, t.`type` AS `type_default`, t.`create_by`, t.`modify_by`, t.`create_date`, t.`modify_date`, t.`ordering`, t.`active`';
			$from='`#__type_convert` tc';
			$innerjoin='RIGHT JOIN `#__type` t ON t.`id`=tc.`type_id` AND tc.`language_id`='.$language_id;
			if ($search) $where[] = 'LOWER(tc.`type`) LIKE "%'.$search.'%"';
		}else{
			$select='t.*';
			$from='`#__type` t';
			$innerjoin='';
			if ($search) $where[] = 'LOWER(t.`type`) LIKE "%'.$search.'%"';
		}//end if

		$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY t.`ordering` ASC"
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_type::show($language_id, $rows, $search, $_pav, $error);
	}//end function

	function modify(&$db, $id)
	{
		$row = new type($db);
		if ($id)
		{
			$row->load($id);
		}//end if
			
		html_type::modify($row, $error);
	}//end function

	function convert(&$db, $type_id, $id)
	{
		global $ln;

		$content_default=content_default($db, $type_id);
		$language_second = $ln->language_second();
		$selected=$language_second["id"].'#'.$language_second["icon"];
		$flag=$language_second["icon"];
		$row = new type_convert($db);
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$content_default=content_default($db, $row->type_id);
		}//end if
			
		html_type::convert($content_default, $selected, $flag, $row, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new type($db);
		$row->publish_array($cid, $publish);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=type');
		redirect('./cpanel.php?module=type&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id;
		$error=false;
		$row=($default["id"]==$language_id)?new type($db):new type_convert($db);
		
		if ($default["id"]==$language_id)
		{
			$modify_date = date("Y-m-d H:m:s");
			if (!$_POST["id"]) 
			{
				$_POST["create_by"] = $_SESSION["member_id"];
				$_POST["create_date"]=$modify_date;
			}else{ 
				$_POST["modify_by"] = $_SESSION["member_id"];
				$_POST["modify_date"]=$modify_date;
			}//end if
		}else{
			$_POST["language_id"] = $language_id;
		}//end if
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) 
			{
				$error=$row->get_error();
			}else{ 
				if ($default["id"]==$language_id) $row->update_order();
			}//end if
		}//end if

		if ($error)
		{
			if ($default["id"]==$language_id)
			{
				html_type::modify($row, $error);
			}else{
				$content_default=content_default($db, $row->type_id);
				$selected=$language_id.'#'.$ln->flag_icon($language_id);
				$flag=$ln->flag_icon($language_id);
					
				html_type::convert($content_default, $selected, $flag, $row, $error);
			}//end if
		}else{
			$goto = trim(strtolower(get_param( $_POST, 'goto', '' )));
			switch ($goto)
			{
				case 'convert':
					redirect('./cpanel.php?module=type&action=convert&type_id='.$row->id);
					break;
				
				case 'addmore':
					redirect('./cpanel.php?module=type&action=new');
					break;
				
				default:
					if ($default["id"] == $language_id) redirect('./cpanel.php?module=type');
					redirect('./cpanel.php?module=type&show='.$row->language_id);	
					break;
			}//end switch
		}//end if
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default;
		
		$row=($default["id"]==$language_id)?new type($db):new type_convert($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			$joins[]=array('label'=>TYPE_ID, 'name'=>'`#__homes`', 'idfield'=>'id', 'joinfield'=>'`type_id`');
			for($i=0;$i<count($cid);$i++)
			{
				if (!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					if ($default["id"]==$language_id)
					{
						$sql_del="DELETE FROM `#__type_convert` WHERE `type_id`=".$cid[$i];
						$db->set_query($sql_del);
						$db->query();
					}//end if
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if


		if ($default["id"]==$language_id) redirect('./cpanel.php?module=type');
		redirect('./cpanel.php?module=type&show='.$language_id);
	}//end function

	function content_default(&$db, $id)
	{
		if (!$id) return false;
		$row = new type($db);
		$row->load($id);
		return $row;
	}//end function
	
	function saveordering(&$db, $language_id, $id) 
	{
		global $default;
		$total = count($id);
		$order = get_param( $_POST, 'order', array(0) );
		$row = new type($db);
		$conditions = array();
		
    	// update ordering values
		for( $i=0; $i < $total; $i++ ) 
		{
			$row->load($id[$i] );
			if ($row->ordering != $order[$i]) 
			{
				$row->ordering = $order[$i];
	        	if (!$row->store()) 
				{
	            	echo "<script> alert('".$db->get_error()."'); window.history.go(-1); </script>\n";
	            	exit();
	        	}//end if
				
	        	// remember to updateOrder this group
	        	$condition="";
	        	$found = false;
	        	
				foreach ($conditions as $cond)
				{
	            	if ($cond[1]==$condition) 
					{
	                	$found = true;
	                	break;
	            	}//end if
				}//end foreach
				
	        	if (!$found) $conditions[] = array($row->id, $condition);
			}//end if
		}//end for
		
		// execute updateOrder for each group
		foreach ($conditions as $cond) 
		{
			$row->load($cond[0]);
			$row->update_order($cond[1]);
		}//end foreach
		
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=type');
		redirect('./cpanel.php?module=type&show='.$row->language_id);
	}//end function

	function move(&$db, $language_id, $inc, $id) 
	{
		global $default;
		$row = new type($db);
		$row->load($id);
		$row->move($inc);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=type');
		redirect('./cpanel.php?module=type&show='.$row->language_id);
	}//end function

	footer_page();
?>