<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/members.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: November 07, 2007
	# Last update: December 05, 2007 
	*/

	include_once("./logged.php");
	require_once("../classes/talktodirector.php");
	require_once("./classes/tree.php");
	require_once("../languages/".$_SESSION['folder']."/talktodirector.php");
	require_once("./talktodirector.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$no_convert = true;

	header_page(MN_FEATURE_AREAS, MN_TALKTODIRECTOR);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
			show($db);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`send_date`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'DESC'));
		if (!$sort_by) $sort_by="ASC";

		$where = array();
		if ($search) 
		{
			$where[] = '(LOWER(`sender`) LIKE "%'.$search.'%" OR LOWER(`email`) LIKE "%'.$search.'%" OR LOWER(`phone`) LIKE "%'.$search.'%" OR LOWER(`fax`) LIKE "%'.$search.'%" OR LOWER(`address`) LIKE "%'.$search.'%" OR LOWER(`title`) LIKE "%'.$search.'%" OR LOWER(`content`) LIKE "%'.$search.'%)';
		}//end if

		$where[] = '`id`>0';

		$sql_total=("SELECT count(*) AS num FROM `#__talktodirector` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();
		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__talktodirector` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_talktodirector::show($rows, $search, $_pav, $group_id, $error);
	}//end function

	function modify(&$db, $id)
	{
		$row = new talktodirector($db);
		if ($id)
		{
			$row->load($id);
		}else{
			$ignore = null;
			$row->bind($_POST, $ignore);
		}//end if
		html_talktodirector::modify($row, $error);
	}//end function

	function save(&$db)
	{
		$row=new talktodirector($db);
			
		$error=false;
		$ignore=null;

		if (!$row->id)
		{
			$row->reply_date=date("Y-m-d");
		}
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error();
		if ($_POST['email_forward']) $email_forward=$_POST['email_forward'];
		else 
			$email_forward="";
		$row->email_forward=$email_forward;	
		
		require_once ('../classes/phpmailer.php');
		global $config;
		$content='<html>
				  <head>
				  <meta http-equiv="Content-Type" content="text/html; charset=UTF-8" />
				  <title>www.saigonvan.com</title>
				  <style type="text/css">
				  <!--
					  td{
							font-family:Verdana, Arial, Helvetica, sans-serif;
							font-size:11px;
							color: #333333;
						}
					  .bold{ font-weight:bold; }
				  -->
				  </style>
				  </head>
				  <body>
				  <table width="550" border="0" cellspacing="1" cellpadding="3">
					<tr>
					  <td colspan="2">--------  Orignial Message   -------
					</td>
					</tr>
					<tr>
					  <td colspan="2"><b>From: </b>';
					$content.=$row->sender;
					$content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>To: </b>';
					$content.=$config->email3;
					$content.='</td>
					</tr>
					<tr>
					<td colspan="2"><b>Send: </b>';
					$content.=show_date($row->send_date);
					$content.='</td>
					</tr>
					<tr>
					  <td colspan="2"><b>Subject: </b>';
					$content.= "Request - Talk to the Director from ". $row->sender;
					$content.='<br />
<br />
<br />
</td>
					</tr>
					<tr>
					  <td colspan="2">';
					$content.=HELLO ." <span class='bold'>".$row->sender."</span>";
					$content.='</td>
					</tr>
					<tr>
					  <td colspan="2">=============================================</td>
					</tr>
					<tr>
						<td width="15%" align="left">'.SENDER.':</td>
						<td class="bold">';
					$content.=$row->sender;
					$content.='</td>
					</tr>';
					if(isset($row->address)){
						$content.='<tr>
							<td align="left" valign="top">'.ADDRESS.':</td>
							<td class="bold">';
								$content.=$row->address;
						$content.='</td>
						</tr>';
					}
					$content.='<tr>
						<td align="left">'.PHONE.':</td>
						<td class="bold">'.$row->phone.' 
					</td>
					</tr>
					
					</table>
				<table width="550" border="0" cellspacing="1" cellpadding="3">
				  <tr>
					<td width="15%" align="left">'.FAX.': </td>
					<td class="bold">'.$row->fax.'</td>
					</tr>
					<tr>
					  <td align="left">'.EMAIL.': </td>
					  <td class="bold">';
					$content.=$row->email;
				$content.='</td>
					</tr>
					<tr>
					  <td align="left">'.COMPANY.': </td>
					  <td class="bold">';
					$content.=$row->company;
				$content.='</td>
					</tr>
					<tr>
					  <td align="left">'.CONTENT.': </td>
					  <td class="bold">';
						$content.=nl2br($row->content);
						$content.='</td>
					</tr>
					<tr>
					  <td colspan="2">=============================================</td>
					</tr>
				  </table>
				   </br></br> '.SYSTEM_MAIL.'
				</body>
				</html>';
		//echo $content;
	
		if($email_forward){
			$email_forward = str_replace("; ", ";", $email_forward);
			$email_forward = explode(";", $email_forward);
			
			for($i=0;$i<count($email_forward); $i++){	
				$mail    = new PHPMailer();
				$mail->CharSet = 'UTF-8'; 
				$mail->IsSMTP(); 
				$mail->SMTPAuth = true; 
				$mail->From     ='webmaster@saigonvan.com';
				$mail->FromName = 'SAIGON VAN';
				$mail->Subject  = "FW: Request - Talk to the Director from ". $row->sender;
				$mail->MsgHTML($content);
				$mail->AddAddress($email_forward[$i], '');
				@$mail->Send();
			}
			
			$error=$row->get_error();
			$row->replied=1;
			if(!$error)
				if (!$row->store())$error=$row->get_error();
			
			if ($error)
			{
				html_talktodirector::modify($row, $error);
			}else{
				redirect("?module=talktodirector");
			}//end if
		}else
			redirect("?module=talktodirector");		
	}//end function

	function remove(&$db, $cid)
	{	
		$row = new talktodirector($db);
		$error=false;

		if (count($cid))
		{
			for($i=0; $i<count($cid); $i++)
			{	
				$row->delete_record($cid[$i]);
			}//end for
		}//end if
		
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=talktodirector');
	}//end function

	footer_page();
?>