<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/services.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: October 08, 2007
	# Last update: January 07, 2008
	*/

	include_once("./logged.php");
	require_once("./classes/tree.php");
	require_once("./classes/services.php");
	require_once("../languages/".$_SESSION['folder']."/services.php");
	require_once("./services.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$service_id = intval(get_param($_REQUEST, 'service_id', 0));
	$box_parent = new tree($db, $language_id, '#__services', '#__services_convert', 'title', 'service_id');
	$page="static"; 

	header_page(MN_FEATURE_AREAS, MN_SERVICES);
	include_once ("./includes/editor/editor.php");

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			//modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;

		case "convert":
			if (!$service_id) $service_id=$id[0];
			convert($db, $service_id, 0);
			break;

		case "editconvert":
			convert($db, $service_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			//remove($db, $language_id, $id);
			break;
		
		default:
			show($db, $language_id);
			break;
	}//end switch

	function show(&$db, $language_id)
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='sc.*, s.`id` AS `id_default`, s.`title` AS `title_default`, s.`content` AS `content_default`, s.`create_by`, s.`modify_by`, s.`create_date`, s.`modify_date`, s.`active`';
			$from='`#__services_convert` sc';
			$innerjoin='RIGHT JOIN `#__services` s ON s.`id`=sc.`service_id` AND sc.`language_id`='.$language_id;
			$sort='sc';
			if ($search) $where[] = 'LOWER(sc.`title`) LIKE "%'.$search.'%" OR LOWER(sc.`content`) LIKE "%'.$search.'%"';
		}else{
			$select='s.*';
			$from='`#__services` s';
			$innerjoin='';
			$sort='s';
			if ($search) $where[] = 'LOWER(s.`title`) LIKE "%'.$search.'%" OR LOWER(s.`content`) LIKE "%'.$search.'%"';
		}//end if

		$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$sort.".".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_services::show($language_id, $rows, $search, $_pav);
	}//end function

	function modify(&$db, $id)
	{
		$editor=new wysiwygPro();

		$row = new services($db);
		if ($id)
		{
			$row->load($id);
		}//end if
			
		html_services::modify($row, $editor, $error);
	}//end function

	function convert(&$db, $service_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$content_default=content_default($db, $service_id);
		//echo '<pre>';print_r($content_default);echo '</pre>';
		$language_second = $ln->language_second();
		$selected=$language_second["id"].'#'.$language_second["icon"];
		$flag=$language_second["icon"];
		$row = new services_convert($db);
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$content_default=content_default($db, $row->service_id);
		}//end if
			
		html_services::convert($content_default, $selected, $flag, $row, $editor, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new services($db);
		$row->publish_array($cid, $publish);
			
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=services');
		redirect('./cpanel.php?module=services&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id;
		$editor = new wysiwygPro();
		$error=false;
		if ($default["id"]==$language_id)
		{
			$row=new services($db);
			$modify_date = date("Y-m-d H:m:s");
			if (!$_POST["id"]) 
			{
				$_POST["create_by"] = $_SESSION["member_id"];
				$_POST["create_date"]=$modify_date;
			}else{ 
				$_POST["modify_by"] = $_SESSION["member_id"];
				$_POST["modify_date"]=$modify_date;
			}//end if
		}else{
			$row = new services_convert($db);
			$_POST["language_id"] = $language_id;
		}//end if
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			if ($default["id"]==$language_id)
			{
				html_services::modify($row, $editor, $error);
			}else{
				$content_default=content_default($db, $row->service_id);
				$selected=$language_id.'#'.$ln->flag_icon($language_id);
				$flag=$ln->flag_icon($language_id);
					
				html_services::convert($content_default, $selected, $flag, $row, $editor, $error);
			}//end if
		}else{
			$convert = intval(get_param($_POST, 'convert', 0));
			if ($convert) redirect('./cpanel.php?module=services&action=convert&service_id='.$row->id);
			if ($default["id"] == $language_id) redirect('./cpanel.php?module=services');
			redirect('./cpanel.php?module=services&show='.$row->language_id);
		}//end if
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default;
		
		$row=($default["id"]==$language_id)?new services($db):new services_convert($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0;$i<count($cid);$i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					if ($default["id"]==$language_id)
					{
						$sql_del="DELETE FROM `#__services_convert` WHERE `service_id`=".$cid[$i];
						$db->set_query($sql_del);
						$db->query();
					}//end if
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		if ($default["id"]==$language_id) redirect('./cpanel.php?module=services');
		redirect('./cpanel.php?module=services&show='.$language_id);
	}//end function

	function content_default(&$db, $id)
	{
		if (!$id) return false;
		$row = new services($db);
		$row->load($id);
		return $row;
	}//end function

	footer_page();
?>