<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/database.php 
	# Description: 
	# Write by: Le Hung
	# Start time: November 06, 2007
	# Last update:  
	*/

	include_once("./logged.php");
	require_once("./classes/pclzip.lib.php");
	require_once("./restore.html.php");
	require_once("../languages/".$_SESSION['folder']."/database.php");
	

	$dir_fs_www_root=path_root();
	$local_backup_path=$dir_fs_www_root."administrator/backups";
	$path_root=$dir_fs_www_root;
	
	$file	= get_param($_POST, "file", null);
	$upfile	= get_param($_FILES, "upfile", null);
	
	$action=trim(strtolower(get_param($_REQUEST, 'action', 'backup' )));

	switch ($action)
	{			
		case "restore_data":
			header_page(MN_DATABASE_AREAS, MN_RESTORE, false);
			restore_data($file,$upfile,$local_backup_path);
			break;
		
		default:
			header_page(MN_DATABASE_AREAS, MN_RESTORE, false);
			restore_form($local_backup_path);
			break;
	}//end switch

	function restore_form($local_backup_path) 
	{
		$uploads_okay = (function_exists('ini_get')) ? ((strtolower(ini_get('file_uploads')) == 'on' || ini_get('file_uploads') == 1) && intval(ini_get('upload_max_filesize'))) : (intval(@get_cfg_var('upload_max_filesize')));
		if ($uploads_okay) $enctype = " enctype=\"multipart/form-data\"";
		else $enctype = '';

		html_database::restore_form($enctype,$uploads_okay,$local_backup_path);
	}//end function

	function restore_data( $file, $uploadedFile, $local_backup_path ) 
	{
		global $db, $action, $path_root;

		if(!is_null($uploadedFile) && is_array($uploadedFile) && $uploadedFile["name"] != "")
		{
			$base_Dir = $path_root. "/uploadfiles/";
			
			if (!move_uploaded_file($uploadedFile['tmp_name'], $base_Dir . $uploadedFile['name']))
			{
				html_database::message(RESTORE_FAILURE." ".CONTACT_WEBMASTER,"", $action);
				return false;
			}//end if
		}//end if

		if ((!$file) && (!$uploadedFile['name']))
		{
			html_database::message(NO_FILE_SPECIFIED,"",$action);
			return;
		}//end if

		if ($file)
		{
			if (isset($local_backup_path))
			{
				$infile		= $local_backup_path . "/" . $file;	
				$upfileFull	= $file;
				$destfile = $path_root."/uploadfiles/$file";

				// If it's a zip file, we copy it so we can extract it
				if(eregi(".\.zip$",$upfileFull))
				{
					copy($infile,$destfile);
				}//end if
			}else{
				html_database::message(BACKUP_PATH_WRONG,"", $action);
				return;
			}//end if
		}else{
			$infile=$path_root."/uploadfiles/".$uploadedFile["name"];
			$upfileFull=$uploadedFile["name"];
		}//end if

		if (!eregi(".\.sql$",$upfileFull) && !eregi(".\.bz2$",$upfileFull) && !eregi(".\.gz$",$upfileFull) && !eregi(".\.zip$",$upfileFull))
		{
			html_database::message(sprintf(INVALID_FILE_EXTENSION, $upfileFull),"", $action);
			return;
		}//end if

		if (substr($upfileFull,-3)==".gz")
		{
			if (function_exists('gzinflate'))
			{
				$fp=fopen("$infile","rb");
				if ((!$fp) || filesize("$infile")==0)
				{
					html_database::message(sprintf(OPEN_INPUT_FILE, $infile),"", $action);
					return;
				}else{
					$content = fread($fp,filesize("$infile"));
					fclose($fp);
					$content = gzinflate(substr($content,10));
				}//end if
			}else{
				html_database::message(PROCESS_GZIP, "", $action);
				return;
			}//end if
		}elseif (substr($upfileFull,-4)==".bz2"){
			if (function_exists('bzdecompress'))
			{
				$fp=fopen("$infile","rb");
				if ((!$fp) || filesize("$infile")==0)
				{
					html_database::message(sprintf(OPEN_INPUT_FILE, $infile),"", $action);
					return;
				}else{
					$content=fread($fp,filesize("$infile"));
					fclose($fp);
					$content=bzdecompress($content);
				}//end if
			}else{
				html_database::message(PROCESS_BZIP,"", $action);
				return;
			}//end if
		}elseif (substr($upfileFull,-4)==".sql"){
			$fp=fopen("$infile","r");
			if ((!$fp) || filesize("$infile")==0)
			{
				html_database::message(sprintf(OPEN_INPUT_FILE, $infile),"", $action);
				return;
			}else{
				$content=fread($fp,filesize("$infile"));
				fclose($fp);
			}//end if
		}elseif (substr($upfileFull,-4)==".zip"){
			// unzip the file
			$base_Dir		= $path_root. "/uploadfiles/";
			$archivename	= $base_Dir . $upfileFull;
			$tmpdir			= uniqid("dbrestore_");

			$isWindows = (substr(PHP_OS, 0, 3) == 'WIN' && stristr ( $_SERVER["SERVER_SOFTWARE"], "microsoft"));
			if($isWindows)
			{
				$extractdir	= str_replace('/','\\',$base_Dir . "$tmpdir/");
				$archivename = str_replace('/','\\',$archivename);
			}else{
				$extractdir	= str_replace('\\','/',$base_Dir . "$tmpdir/");
				$archivename = str_replace('\\','/',$archivename);
			}//end if

			$zipfile	= new PclZip($archivename);
			
			
			if($isWindows) 
				define('OS_WINDOWS',1);
			$ret = $zipfile->extract(PCLZIP_OPT_PATH,$extractdir);
			
			if($ret == 0)
			{
				html_database::message(UNRECOVERABLE." ".$zipfile->errorName(true)."'","", $action);
				return false;
			}//end if

			$filesinzip = $zipfile->listContent();
			if(is_array($filesinzip) && count($filesinzip) > 0)
			{
				$fp	= fopen($extractdir . $filesinzip[0]["filename"],"r");
				$content = fread($fp,filesize($extractdir . $filesinzip[0]["filename"]));
				fclose($fp);

				// Cleanup
				deldir($extractdir);
				unlink($path_root. "/uploadfiles/$upfileFull");
			}else{
				html_database::message(sprintf(NO_SQL_FILE, $upfileFull),"",$action);
				return;
			}//end if
		}else{
			html_database::message(UNRECOVERABLE_INPUT." ($infile : $upfileFull)","", $action);
			return;
		}//end if

		$decodedIn	= explode(chr(10),$content);
		$decodedOut	= "";
		$queries	= 0;

		foreach ($decodedIn as $rawdata)
		{
			$rawdata=trim($rawdata);
			if (($rawdata!="") && ($rawdata{0}!="#"))
			{
				$decodedOut .= $rawdata;
				if (substr($rawdata,-1)==";")
				{
					if  ((substr($rawdata,-2)==");") || (strtoupper(substr($decodedOut,0,6))!="INSERT"))
					{
						if (eregi('^(DROP|CREATE)[[:space:]]+(IF EXISTS[[:space:]]+)?(DATABASE)[[:space:]]+(.+)', $decodedOut))
						{
							html_database::message("Error! Your input file contains a DROP or CREATE DATABASE statement. Please delete these statements before trying to restore the file.</p>","",$option,$action);
							return;
						}//end if
						
						$db->set_query($decodedOut);
						$decodedOut="";
						$queries++;
					}//end if
				}//end if
			}//end if
		}//end foreach

		html_database::message(sprintf(RESTORED_SUCCESS, $queries),"", $action);
		return;
	}//end function
	
	function deldir($dir)
	{
		$current_dir = opendir($dir);
		while($entryname = readdir($current_dir))
		{
    		if(is_dir("$dir/$entryname") and ($entryname != "." and $entryname!=".."))
    		{
				deldir("${dir}/${entryname}");
			}elseif($entryname != "." and $entryname!=".."){
				unlink("${dir}/${entryname}");
			}//end if
		}//end while
		
		closedir($current_dir);
		rmdir($dir);
	}//end function
	
	function path_root()
	{
		$script_filename = getenv("PATH_TRANSLATED");
		if (empty($script_filename)) $script_filename = getenv("SCRIPT_FILENAME");
		
		$script_filename = str_replace('\\', '/', $script_filename);
		$script_filename = str_replace('//', '/', $script_filename);
	
		$dir_fs_www_root_array = explode('/', dirname($script_filename));
		$dir_fs_www_root = array();
		for ($i=0, $n=sizeof($dir_fs_www_root_array)-1; $i<$n; $i++) 
		{
			$dir_fs_www_root[] = $dir_fs_www_root_array[$i];
		}//end for
		$dir_fs_www_root = implode('/', $dir_fs_www_root) . '/';
		return $dir_fs_www_root;
	}//end function

	footer_page();
?>