<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/customers.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/customers.php");
	require_once("./classes/records.php");
	require_once("./classes/tree.php");
	require_once("../languages/".$_SESSION['folder']."/records.php");
	require_once("./records.html.php");
	require_once("./classes/upload.php");
	require_once("./includes/define.php");
	
	$dir_path="../filesmanager/records/";
	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$box_location = new tree($db, $language_id, '#__locations', '', 'name', '');
	$no_convert = true;

	header_page(MN_TRACKING_AREAS, MN_RECORD_MANAGEMENT);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
			modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove_contract":
			remove_contract($db, $_GET['id'], $_GET['customer_id']);
			break;
				
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$sql="DELETE FROM `#__invoices_reports` WHERE `title`='' AND `filename`=''";
		$db->set_query($sql);
		$db->query();
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`customer`')));
		if (!$field_sort) $field_sort="c.id";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$where = array();

		if ($search) 
		{
			$where[] = '(LOWER(m.contract) LIKE "%'.$search.'%")';
		}//end if
		
		$where[] = '`record_management`=1 ';

		/*$sql_total=("SELECT count(*) AS num FROM `#__customers` INNER JOIN `#__record_management` 
        ON (`#__customers`.id = `#__record_management`.customer_id) "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));*/
				
		$sql_total=("SELECT count(*) AS num FROM `#__customers`" 
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
						
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);
		
		
		$sql_sel=("SELECT m.*, c.* FROM `#__record_management` m RIGHT JOIN `#__customers` c ON m.`customer_id`=c.`id`"
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
				
		/*$sql_sel=("SELECT * FROM `#__customers` INNER JOIN `#__record_management` 
        ON (`#__customers`.id = `#__record_management`.customer_id) "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);*/
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_records::show($rows, $search, $_pav, $country_id, $error);
	}//end function

	function modify(&$db, $id)
	{
		
		
		$row = new customers($db);
		if ($id)
		{
			$row->load($id);
		}else{
			$row->bind($_POST, '');
		}//end if
		
		// Check customer id exist in record management.
		// If not exist, so insert into record management. 
		$sql = "SELECT * FROM `#__record_management` WHERE `customer_id`=".$id;
		$db->set_query($sql);
		//echo $db->get_query();
		$record=$db->load_record_list();
		if(!count($record)){
			$now = date("Y-m-d H:i:s");
			$sql_insert = "INSERT INTO `#__record_management`(`customer_id`,`create_date`,`modify_date`) VALUES (".$id.", '".$now."', '".$now."')";
			$db->set_query($sql_insert);
			$db->query();
			$sql="SELECT * FROM `#__record_management` WHERE `customer_id`=".$id;
			$db->set_query($sql);
			//echo $db->get_query();
			$record=$db->load_record_list();
		}
		
		// End check record management
	
		// Check customer id exist in report.
		// If not exist, so insert into report. 
		
		
		$sql = "SELECT * FROM `#__invoices_reports` WHERE `customer_id`=".$id." AND `report`=1 ORDER BY `id` DESC LIMIT 0,3";
		$db->set_query($sql);
		//echo $db->get_query();
		$report=$db->load_record_list();
		if(!count($report)){
			
			$sql_insert = "INSERT INTO `#__invoices_reports`(`customer_id`,`report`) VALUES (".$id.", '1')";
			$db->set_query($sql_insert);
			$db->query();
			$sql="SELECT * FROM `#__invoices_reports` WHERE `customer_id`=".$id." AND `report` = 1 ORDER BY id DESC" ;
			$db->set_query($sql);
			//echo $db->get_query();
			$report=$db->load_record_list();
		}
		
		$report_count = count($report);
		switch($report_count) {
			case 1: 
				$arr_report[0]=$report[0];
				$arr_report[1]=NULL;
				$arr_report[2]= NULL;
				break; 
			case 2: 	
			    $arr_report[0]=$report[0];
				$arr_report[1]= $report[1];
				$arr_report[2]= NULL;
				break; 	
			case 3: 	
			    $arr_report=$report;
				break; 		
				
		}
		// Check customer id exist in invoice .
		// If not exist, so insert into invoice  
		$sql = "SELECT * FROM `#__invoices_reports` WHERE `customer_id`=".$id." AND `report`=2 ORDER BY `id` DESC LIMIT 0,3";
		
		$db->set_query($sql);
		$invoice=$db->load_record_list();
		if(!count($invoice)){
			$sql_insert = "INSERT INTO `#__invoices_reports`(`customer_id`,`report`) VALUES (".$id.", '2')";
			$db->set_query($sql_insert);
			$db->query();			
			$sql="SELECT * FROM `#__invoices_reports` WHERE `customer_id`=".$id." AND `report` = 2 ORDER BY `id` DESC" ;
			$db->set_query($sql);
			$invoice=$db->load_record_list();
		}
		$invoice_count = count($invoice);
		switch($invoice_count) {
			case 1: 
				$arr_invoice[0]= $invoice[0];
				$arr_invoice[1]= NULL;
				$arr_invoice[2]= NULL;
				break; 
			case 2: 	
			    $arr_invoice[0]= $invoice[0];
				$arr_invoice[1]= $invoice[1];
				$arr_invoice[2]= NULL;
				break; 	
			case 3: 	
			    $arr_invoice= $invoice;
				break; 		
				
		}
		
		html_records::modify($row,$record, $arr_invoice, $arr_report, $error);
	}//end function

	function publish(&$db, $cid=null, $publish=1)
	{
		$row = new customers($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=customers');
	}//end function

	
	function save(&$db)
	{
		global $dir_path;
		$customer_id = $_POST['id'];	
		$prefix="";//rand(0, 99999)."-";
		$row=new records($db);
		$error="";
		
		$sql = "UPDATE `#__record_management` SET `contract`='".$_POST['contract']."', `validity` = '".$_POST['validity']."', `remarks`= '".$_POST['remarks']."' WHERE `customer_id`= ".$customer_id;
		$db->set_query($sql);
		$db->query();
		// end check record management
		
		$upload = new upload($_FILES["filereport"], $dir_path, $prefix, $_FILES["filereport"]["name"]);
		
		if (($_FILES["filereport"]["name"]))
		{
			$filereport=$_FILES["filereport"]["name"];
			$filetype=$_FILES["filereport"]["type"];
		}
		if ($_FILES["filereport"]["name"])
		{
			if (!$upload->document()) 
			{
				$row->_error=DOCUMENT_FILE_NOTE;
				$error=$row->get_error();
			}else if (!$upload->file_size()){
				$row->_error=sprintf(CHECK_FILE_SIZE, intval(FILE_LIMIT/1048576));
				$error=$row->get_error();
			}else{
				if (!$upload->upload_file())
				{
					$row->_error=CHECK_SOURCE_DEST;
					$error=$row->get_error();
				}//end if
				$filereport=$prefix.strtolower($upload->clear_space($filereport));
			}//end if
		}//end if
		if ($_FILES["filereport"]["name"]){
			if(check_report(&$db, $customer_id, 1))
				$sql = "INSERT INTO `#__invoices_reports`(`customer_id`,`title`, `filename`, `filetype`,`report`,`active` ) VALUES ('".$customer_id."','".$_POST['R']."','".$filereport."', '".$filetype."', '1', '1')";
			else 
				$sql = "UPDATE `#__invoices_reports` SET `title` ='".$_POST['R']."', `filename` = '".$filereport."', `filetype` = '".$filetype."' WHERE 	`customer_id`= ".$customer_id." AND `report` =1";	
			
			$db->set_query($sql);
			$db->query();
		}		
		
		$sql= "SELECT * FROM `#__invoices_reports` WHERE `report`=1 AND `customer_id`= ".$customer_id." ORDER BY `id` DESC LIMIT 3,100";
		$db->set_query($sql);
			//echo $db->get_query();
		$invoice_d=$db->load_record_list();
		$invoice_d_count = count($invoice_d);
		if($invoice_d_count){
			for($i=0;$i<$invoice_d_count;$i++){
				remove_contract_list($db, $invoice_d[$i]['id'], $customer_id);
			}
		}
		$upload = new upload($_FILES["fileinvoice"], $dir_path, $prefix, $_FILES["fileinvoice"]["name"]);
		
		if (($_FILES["fileinvoice"]["name"]))
		{
			$fileinvoice=$_FILES["fileinvoice"]["name"];
			$filetype=$_FILES["fileinvoice"]["type"];
		}
		if ($_FILES["fileinvoice"]["name"])
		{
			if (!$upload->document()) 
			{
				$row->_error=DOCUMENT_FILE_NOTE;
				$error=$row->get_error();
			}else if (!$upload->file_size()){
				$row->_error=sprintf(CHECK_FILE_SIZE, intval(FILE_LIMIT/1048576));
				$error=$row->get_error();
			}else{
				if (!$upload->upload_file())
				{
					$row->_error=CHECK_SOURCE_DEST;
					$error=$row->get_error();
				}//end if
				$fileinvoice=$prefix.strtolower($upload->clear_space($fileinvoice));
			}//end if
		}//end if
		if (($_FILES["fileinvoice"]["name"])){
			if(check_report(&$db, $customer_id, 2))
				$sql = "INSERT INTO `#__invoices_reports`(`customer_id`,`title`, `filename`, `filetype`,`report`,`active` ) VALUES ('".$customer_id."','".$_POST['I']."','".$fileinvoice."', '".$filetype."', '2', '1')";
			else 
				$sql = "UPDATE `#__invoices_reports` SET `title` ='".$_POST['I']."', `filename` = '".$fileinvoice."', `filetype` = '".$filetype."' WHERE 	`customer_id`= ".$customer_id." AND `report`= 2";	
			
			$db->set_query($sql);
			$db->query();	
		}				
		
		$sql= "SELECT * FROM `#__invoices_reports` WHERE `report`=2 AND `customer_id`= ".$customer_id." ORDER BY `id` DESC LIMIT 3,100";
		$db->set_query($sql);
			//echo $db->get_query();
		$invoice_d=$db->load_record_list();
		$invoice_d_count = count($invoice_d);
		if($invoice_d_count){
			for($i=0;$i<$invoice_d_count;$i++){
				remove_contract_list($db, $invoice_d[$i]['id'], $customer_id);
			}
		}
		
		if($error)
		{
			html_records::modify($row, $error);
		}else{
			redirect("?module=records");
		}//end if
	}//end function
	
	
	function remove(&$db, $cid)
	{	
		$row = new customers($db);
		$error=false;

		if (count($cid))
		{
			$joins='';
			for($i=0; $i<count($cid); $i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=records');
	}//end function

	function remove_contract(&$db, $id, $customerid)
	{
		global $dir_path;
		$row=new records($db);
		$invoices_reports=$row->delete_invoices_reports($id);
		if ($invoices_reports)
		{
			foreach ($invoices_reports as $file_delete)
			{

				@unlink($dir_path.$file_delete['filename']);
			}//end foreach
			$db->set_query('DELETE FROM `#__invoices_reports` WHERE `id`='.$id);
			$db->query();
		}//end if
		$row->delete_record($id);
		redirect('./cpanel.php?module=records&action=edit&id[]='.$customerid);	
	}//end function

	function remove_contract_list(&$db, $id)
	{
		global $dir_path;
		$row=new records($db);
		$invoices_reports=$row->delete_invoices_reports($id);
		if ($invoices_reports)
		{
			foreach ($invoices_reports as $file_delete)
			{

				@unlink($dir_path.$file_delete['filename']);
			}//end foreach
			$db->set_query('DELETE FROM `#__invoices_reports` WHERE `id`='.$id);
			$db->query();
		}//end if
		$row->delete_record($id);
		//redirect('./cpanel.php?module=records&customer_id='.$_POST['customer_id']);	
	}//end function
	
	
	function country(&$db, $id)
	{
		$db->set_query('SELECT `name` FROM `#__locations` WHERE `id`='.$id);
		return $db->load_result();
	}//end function
	function check_report(&$db, $customer_id, $report)
	{
		$sql ="SELECT * FROM `#__invoices_reports` WHERE `customer_id`=".$customer_id." AND `title` != '' AND `filename` != '' AND  `report`=".$report;
		$db->set_query($sql);
		$rs=$db->load_record_list();
		if(count($rs)){
				return 1;
		}
		return 0;
	}//end function

	footer_page();
?>