<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/record_management_doc.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: December 27, 2007
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/tree.php");
	require_once("./classes/upload.php");
	require_once("./classes/record_management_doc.php");
	require_once("../languages/".$_SESSION['folder']."/record_management_doc.php");
	require_once("./record_management_doc.html.php");
	require_once("./includes/define.php");

	$dir_path="../filesmanager/images/";
	$dir_path2="../filesmanager/documents/";
	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$record_management_doc_id = intval(get_param($_REQUEST, 'record_management_doc_id', 0));
	$no_convert = true;

	header_page(MN_FEATURE_AREAS, MN_RECORD_MANAGEMENT_DOC);
	include_once ("./includes/editor/editor.php");

	//print_r($_SESSION);

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			modify($db, $language_id, 0);
			break;
		
		case "edit":
			modify($db, $language_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		default:
			show($db, $language_id);
			break;
	}//end switch

	function show(&$db, $language_id)
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'DESC'));
		if (!$sort_by) $sort_by="DESC";

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='nc.*';
			$from='`#__record_management_doc_convert` nc';
			$innerjoin='RIGHT JOIN `#__record_management_doc` n ON n.`id`=nc.`record_management_doc_id` AND nc.`language_id`='.$language_id;
			if ($search) $where[] = 'LOWER(nc.`title`) LIKE "%'.$search.'%"  LOWER(nc.`content`) LIKE "%'.$search.'%"';
		}else{
			$select='`#__record_management_doc`.*';
			$from='`#__record_management_doc` n';
			$innerjoin='';
			if ($search) $where[] = 'LOWER(n.`title`) LIKE "%'.$search.'%" OR LOWER(n.`content`) LIKE "%'.$search.'%"';
		}//end if

		$where[]="`language_id`=".$language_id;

		$sql_total=("SELECT count(*) AS num FROM `#__record_management_doc`"
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__record_management_doc` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_record_management_doc::show($language_id, $rows, $search, $_pav);
	}//end function

	function modify(&$db, $language_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$editor2=new wysiwygPro();
		$row = new record_management_doc($db);
		$selected=$language_id.'#'.$ln->flag_icon($language_id);
		$flag=$ln->flag_icon($language_id);
		
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			
		}//end if
			
		html_record_management_doc::modify($row, $selected, $flag, $editor, $editor2, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new record_management_doc($db);
		$row->publish_array($cid, $publish);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=record_management_doc');
		redirect('./cpanel.php?module=record_management_doc&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id, $dir_path, $dir_path2;
		$error=false;
		$row = new record_management_doc($db);

		
		$editor = new wysiwygPro();
		$editor2 = new wysiwygPro();
		
		
		$_POST["language_id"] = $language_id;

		
		
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			$selected=$language_id.'#'.$ln->flag_icon($language_id);
			$flag=$ln->flag_icon($language_id);
			html_record_management_doc::modify($row, $selected, $flag, $editor, $editor2, $error);
		}else{
			$goto = trim(strtolower(get_param( $_POST, 'goto', '' )));
			if ($goto) redirect('./cpanel.php?module=record_management_doc&action=new');
			redirect('./cpanel.php?module=record_management_doc&show='.$row->language_id);
		}//end if
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default, $dir_path, $dir_path2;
		
		$row = new record_management_doc($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0;$i<count($cid);$i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		redirect('./cpanel.php?module=record_management_doc&show='.$language_id);
	}//end function

	footer_page();
?>