<?php
	/*
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/photos.php
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: December 07, 2007
	# Last update: January 12, 2008
	*/

	include_once("./logged.php");
	require_once("./classes/upload.php");
	require_once("./classes/photos.php");
	require_once("./includes/define.php");
	require_once("../includes/sajax.php");
	require_once("../languages/".$_SESSION['folder']."/photos.php");
	require_once("./photos.html.php");

	$dir_path="../filesmanager/photos/";
	$action=trim(strtolower(get_param($_REQUEST, 'action', 'photos' )));
	if (($action=='') || ($action=='cancel')) $action='photos';

	sajax_init();
	eval(sajax_export('show_photo', 'draw_form'));
	sajax_handle_client_request();

	header_page(MN_FEATURE_AREAS, MN_HOME_SEARCH.' :: '.MN_HOME_PHOTOS);

	switch ($action)
	{
		case "publish":
			publish($db, $id, 1);
			break;

		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
			additem($db);
			break;

		case "save":
			save($db);
			break;
			
		case "update":
			update($db);
			break;	

		case "remove":
			remove($db, $id);
			break;

		default:
			show($db);
			break;
	}//end switch

	function show(&$db)
	{
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));

		$home_id = intval(get_param($_REQUEST, 'home_id', 0));

		$where = array();

		if ($search)
		{
			$where[] = 'LOWER(`image`) LIKE "%'.$search.'%"';
		}//end if

		if ($home_id) $where[]="`home_id`=".$home_id;

		$sql_total=("SELECT count(*) AS num FROM `#__home_photos`"
		. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__home_photos`"
		. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
		. "\n ORDER BY `id` ASC"
		. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();

		html_photos::show($rows, $search, $_pav, $home_id);
	}//end function

	function additem(&$db)
	{
		$number = intval(get_param($_POST, 'number', 5));
		$row=new home_photos($db);
		html_photos::additem($row, $error, $number, '', '');
	}//end function

	function publish(&$db, $cid=null, $publish=1)
	{
		$row = new home_photos($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=photos&home_id='.$_POST['home_id']);
	}//end function

	function save(&$db)
	{
		//echo '<pre>';print_r($_FILES);echo '</pre>';
		//exit();
		//if (!$_POST['id']) insert_array($db, $_POST['number']);
		//else update_item($db);
		insert_array($db, $_POST['number']);
	}//end function

	function remove(&$db, $cid)
	{
		global $dir_path;

		$row=new home_photos($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0; $i<count($cid); $i++)
			{
				$file=$row->delete_file($cid[$i]);
				@unlink($dir_path.'/source/'.$file);
				@unlink($dir_path.'/large/'.$file);
				@unlink($dir_path.'/small/'.$file);
				$row->delete_record($cid[$i]);
			}//end for
		}//end if
		redirect('./cpanel.php?module=photos&home_id='.$_POST['home_id']);
	}//end function
	
	function update(&$db)
	{
		global $dir_path;
		
		$sql_sel=("SELECT * FROM `#__home_photos`"); 
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		$sql = "UPDATE `#__home_photos` SET ";
		if (count($rows))
		{
			for($i=0; $i<count($rows); $i++)
			{
					$j=$rows[$i]['id'];
					$visitor = isset($_POST['vs'.$j])?1:0;
					$sql_v= " `visitor`=".$visitor; 
					$sql_v .= " WHERE `id`=".$j;
					$db->set_query($sql.$sql_v);
					$db->query();
					
					$login = isset($_POST['lg'.$j])?1:0;
					$sql_l= " `login`=".$login; 
					$sql_l .= " WHERE `id`=".$j;
					$db->set_query($sql.$sql_l);
					$db->query();
			}
		}
		redirect('./cpanel.php?module=photos&home_id='.$_POST['home_id']);
	}//end function

	function show_photo($id)
	{
		global $db;
		$db->set_query('SELECT `type_id`, `city_id`, `district_id`, `code`, `image`, `area`, `address_code` FROM `#__homes` WHERE `id`='.$id);
		$row=$db->load_record();
		if ($row)
		{
			$type_info=author_info($db, '#__type', $row["type_id"]);
			$city_info=author_info($db, '#__city', $row["city_id"]);
			$district_info=author_info($db, '#__city', $row["district_id"]);
			$html='<br />';
			$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td valign="top" width="35%"><img src="../filesmanager/photos/small/'.$row['image'].'" /></td>';
			$html.='<td valign="top" class="space5px_left">';
			$html.='<table width="100%" border="0" cellspacing="0" cellpadding="0">';
			$html.='<tr>';
			$html.='<td class="active" colspan="2">'.$row['code'].'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td class="bold" colspan="2">('.$row['area'].') '.$row['address_code'].'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td class="bold" width="20%"><br />'.TYPE.'</td>';
			$html.='<td><br />: '.$type_info['type'].'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td class="bold">'.CITY.'</td>';
			$html.='<td>: '.$city_info['name'].'</td>';
			$html.='</tr>';
			$html.='<tr>';
			$html.='<td class="bold">'.DISTRICT.'</td>';
			$html.='<td>: '.$district_info['name'].'</td>';
			$html.='</tr>';
			$html.='</table>';
			$html.='</td>';
			$html.='</tr>';
			$html.='</table>';
			return $html;
		}//end if
	}//end function

	function draw_form($number)
	{
		global $draw_html;
		return $draw_html->draw_form_input_photo($number);
	}//end function

	function insert_array(&$db, &$number)
	{
		global $dir_path;

		$prefix=rand(0, 99999)."-";

		$error=array();
		for($i=0; $i<$number; $i++)
		{
			$row[$i] =& new home_photos($db);

			//add file attach
			$upload = new upload($_FILES['image']['tmp_name'][$i], $dir_path, $prefix, $_FILES['image']['name'][$i], $_FILES['image']['size'][$i]);
			
			if ($_FILES['image']['name'][$i])
			{
				if (!$upload->image())
				{
					$row[$i]->_error=PHOTO_FILE_NOTE;
					$error[]=$row[$i]->get_error();
				}else if (!$upload->file_size()){
					$row[$i]->_error=sprintf(CHECK_FILE_SIZE, intval(FILE_LIMIT/1048576));
					$error[]=$row[$i]->get_error();
				}else{
					if (!$upload->upload_resize_image(FILE_SMALL, FILE_LARGE, 'source'))
					{
						$row[$i]->_error=CHECK_SOURCE_DEST;
						$error[]=$row[$i]->get_error();
					}//end if

					$row[$i]->image=$prefix.strtolower($upload->clear_space($_FILES["image"]["name"][$i]));
					$row[$i]->title=$_POST["title"][$i];
					$row[$i]->home_id=$_POST["home_id"];


					if (!$row[$i]->check()) 
					{
						$error[]=$row[$i]->get_error();
					}else{				
						if (!$row[$i]->store())
						{
							$error[]=$row[$i]->get_error();
						}else{
							unset($row[$i]);
							//array_splice($row, $i, 1);												
						}//end if
					}//end if
				}//end if
			}//end if
			//end file attach
		}//end for

		if ($error)
		{	
			$number=count($row);
			html_photos::additem($row, $row_not_error, $number, $_POST['home_id']);
		}else{
			redirect('./cpanel.php?module=photos&home_id='.$_POST['home_id']);
		}//end if
	}//end function

	function homes($selected='', $attribs='', $str='')
	{
		global $db, $default, $ln, $language_id;

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='hc.`area`, hc.`address_code`, h.`id`, h.`code`';
			$from='`#__homes_convert` hc';
			$innerjoin='RIGHT JOIN `#__homes` h ON h.`id`=hc.`home_id` AND hc.`language_id`='.$language_id;
		}else{
			$select='h.`id`, h.`code`, h.`area`, h.`address_code`';
			$from='`#__homes` h';
			$innerjoin='';
		}//end if

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY h.`code` ASC");
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();

		$html='';
		$html.='<select name="home_id" id="home_id" '.$attribs.'>';
		$html.='<option value="">'.$str.'</option>';
		if ($rows)
		{
			for ($i=0, $n=count($rows); $i<$n; $i++)
			{
				$sel = ($rows[$i]["id"] == $selected ?' selected="selected"' : '');
				
				$html.='<option value='.$rows[$i]["id"].$sel.'>'.$rows[$i]['code'].'('.$rows[$i]['area'].' - '.$rows[$i]['address_code'].')'.'</option>';
			}//end for
		}//end if
		$html.='</select>';
		return $html;
	}//end function

	footer_page();
?>