<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/news.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: December 27, 2007
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/tree.php");
	require_once("./classes/upload.php");
	require_once("./classes/news.php");
	require_once("../languages/".$_SESSION['folder']."/news.php");
	require_once("./news.html.php");
	require_once("./includes/define.php");

	$dir_path="../filesmanager/images/";
	$dir_path2="../filesmanager/documents/";
	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$news_id = intval(get_param($_REQUEST, 'news_id', 0));
	$no_convert = true;

	header_page(MN_FEATURE_AREAS, MN_NEWS);
	include_once ("./includes/editor/editor.php");

	//print_r($_SESSION);

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			modify($db, $language_id, 0);
			break;
		
		case "edit":
			modify($db, $language_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		default:
			show($db, $language_id);
			break;
	}//end switch

	function show(&$db, $language_id)
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'DESC'));
		if (!$sort_by) $sort_by="DESC";

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='nc.*';
			$from='`#__news_convert` nc';
			$innerjoin='RIGHT JOIN `#__news` n ON n.`id`=nc.`news_id` AND nc.`language_id`='.$language_id;
			if ($search) $where[] = 'LOWER(nc.`title`) LIKE "%'.$search.'%" OR LOWER(nc.`intro`) LIKE "%'.$search.'%" OR LOWER(nc.`content`) LIKE "%'.$search.'%"';
		}else{
			$select='`#__news`.*';
			$from='`#__news` n';
			$innerjoin='';
			if ($search) $where[] = 'LOWER(n.`title`) LIKE "%'.$search.'%" OR LOWER(n.`intro`) LIKE "%'.$search.'%" OR LOWER(n.`content`) LIKE "%'.$search.'%"';
		}//end if

		$where[]="`language_id`=".$language_id;

		$sql_total=("SELECT count(*) AS num FROM `#__news`"
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__news` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_news::show($language_id, $rows, $search, $_pav);
	}//end function

	function modify(&$db, $language_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$editor2=new wysiwygPro();
		$row = new news($db);
		$selected=$language_id.'#'.$ln->flag_icon($language_id);
		$flag=$ln->flag_icon($language_id);

		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
		}//end if
			
		html_news::modify($row, $selected, $flag, $editor, $editor2, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new news($db);
		$row->publish_array($cid, $publish);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=news');
		redirect('./cpanel.php?module=news&show='.$language_id);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id, $dir_path, $dir_path2;
		$error=false;
		$row = new news($db);

		//begin file attach
		$prefix=rand(0, 99999)."-";
		$upload = new upload($_FILES["image"], $dir_path, $prefix, $_FILES["image"]["name"]);
		
		if (($_FILES["image"]["name"]) && ($_POST["old_file"]))
		{
			@unlink($dir_path.$_POST["old_file"]);	
			$image=$_FILES["image"]["name"];
		}else if(($_FILES["image"]["name"]) && ($_POST["old_file"]=="")){
			$image=$_FILES["image"]["name"];
			$_POST["image"]=$_FILES["image"]["type"];
		}else{
			$_POST["image"]=$_POST["old_file"];
		}//end if

		if ($_FILES["image"]["name"])
		{
			if (!$upload->image()) 
			{
				$row->_error=PHOTO_FILE_NOTE;
				$error=$row->get_error();
			}else if (!$upload->file_size()){
				$row->_error=sprintf(CHECK_FILE_SIZE, intval(FILE_LIMIT/1048576));
				$error=$row->get_error();
			}else{
				if (!$upload->upload_resize_image(150, 600, 'source'))
					{
						$row[$i]->_error=CHECK_SOURCE_DEST;
						$error[]=$row[$i]->get_error();
					}//end if
				$_POST["image"]=$prefix.strtolower($upload->clear_space($image));
			}//end if
		}//end if
		
		if (isset($_POST['remove']) && ($_POST['remove']))
		{
			unlink($dir_path.$_POST["old_file"]);	
			$_POST["image"]='';
		}//end if
		//end file attach

		$upload2 = new upload($_FILES["filename"], $dir_path2, $prefix, $_FILES["filename"]["name"]);
		
		if (($_FILES["filename"]["name"]) && ($_POST["old_file2"]))
		{
			@unlink($dir_path2.$_POST["old_file2"]);
			$filename=$_FILES["filename"]["name"];
			$filetype=$_FILES["filename"]["type"];
		}else if(($_FILES["filename"]["name"]) && ($_POST["old_file2"]=="")){
			$filename=$_FILES["filename"]["name"];
			$filetype=$_FILES["filename"]["type"];
		}else{
			$_POST["filename"]=$_POST["old_file2"];
			$_POST["filetype"]=$_POST["old_filetype"];
		}//end if

		if ($_FILES["filename"]["name"])
		{
			if (!$upload2->document()) 
			{
				$row->_error=DOCUMENT_FILE_NOTE;
				$error=$row->get_error();
			}else if (!$upload2->file_size()){
				$row->_error=sprintf(CHECK_FILE_SIZE, intval(FILE_LIMIT/1048576));
				$error=$row->get_error();
			}else{
				if (!$upload2->upload_file())
				{
					$row->_error=CHECK_SOURCE_DEST;
					$error=$row->get_error();
				}//end if
				$_POST["filename"]=$prefix.strtolower($upload2->clear_space($filename));
				$_POST["filetype"]=$filetype;
			}//end if
		}//end if

		if (isset($_POST['remove2']) && ($_POST['remove2']))
		{
			unlink($dir_path2.$_POST["old_file2"]);	
			$_POST["filename"]='';
			$_POST["filetype"]='';
		}//end if
		//end file attach


		$editor = new wysiwygPro();
		$editor2 = new wysiwygPro();
		
		$modify_date = date("Y-m-d H:m:s");
		if (!$_POST["id"]) 
		{
			$_POST["create_by"] = $_SESSION["member_id"];
			$_POST["create_date"]=$modify_date;
		}else{ 
			$_POST["modify_by"] = $_SESSION["member_id"];
			$_POST["modify_date"]=$modify_date;
		}//end if
		$_POST["language_id"] = $language_id;

		if ($_POST['publish_date']) $_POST['publish_date']=db_date($_POST['publish_date']);
		else $_POST['publish_date']= date("Y-m-d");

		if ($_POST['expire_date']) $_POST['expire_date']=db_date($_POST['expire_date']);
		
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			$selected=$language_id.'#'.$ln->flag_icon($language_id);
			$flag=$ln->flag_icon($language_id);
			html_news::modify($row, $selected, $flag, $editor, $editor2, $error);
		}else{
			$goto = trim(strtolower(get_param( $_POST, 'goto', '' )));
			if ($goto) redirect('./cpanel.php?module=news&action=new');
			redirect('./cpanel.php?module=news&show='.$row->language_id);
		}//end if
	}//end function

	function remove(&$db, $language_id, $cid)
	{
		global $default, $dir_path, $dir_path2;
		
		$row = new news($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0;$i<count($cid);$i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$file=$row->delete_file($cid[$i]);
					@unlink($dir_path2.'/'.$file);
					$image=$row->delete_image($cid[$i]);
					@unlink($dir_path.'/'.$image);
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		redirect('./cpanel.php?module=news&show='.$language_id);
	}//end function

	footer_page();
?>