<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/members.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: November 07, 2007
	# Last update: December 05, 2007 
	*/

	include_once("./logged.php");
	require_once("../classes/members.php");
	require_once("./classes/tree.php");
	require_once("../languages/".$_SESSION['folder']."/members.php");
	require_once("./members.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$box_group = new tree($db, $language_id, '#__groups_member', '', 'group', '');
	$no_convert = true;

	header_page(MN_FEATURE_AREAS, MN_MEMBERS." :: ".MN_MEMBERS);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
				modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`fullname`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$group_id=intval(get_param($_POST, 'group_id', 0));

		$where = array();

		if ($search) 
		{
			$where[] = '(LOWER(`username`) LIKE "%'.$search.'%" OR LOWER(`email`) LIKE "%'.$search.'%" OR LOWER(`fullname`) LIKE "%'.$search.'%" OR LOWER(`company`) LIKE "%'.$search.'%" OR LOWER(`address`) LIKE "%'.$search.'%" OR LOWER(`address2`) LIKE "%'.$search.'%" OR LOWER(`phone`) LIKE "%'.$search.'%" OR LOWER(`mobile`) LIKE "%'.$search.'%" OR LOWER(`fax`) LIKE "%'.$search.'%" OR LOWER(`note`) LIKE "%'.$search.'%")';
		}//end if

		if ($group_id) $where[] = '`group_id`='.$group_id;
		$where[] = '`id`>0';

		$sql_total=("SELECT count(*) AS num FROM `#__members` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__members` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_members::show($rows, $search, $_pav, $group_id, $error);
	}//end function

	function modify(&$db, $id)
	{
		$row = new members($db);
		if ($id)
		{
			$row->load($id);
		}//end if

		html_members::modify($row, $error);
	}//end function

	function publish(&$db, $cid=null, $publish=1)
	{
		if (count($cid))
		{
			$row=new members($db);
			$error=false;
			if ((in_array($_SESSION["member_id"], $cid)) && ($publish==0))
			{
				$row->_error=CANNOT_PUBLISH_YOUR_SEFL;
				$error=$row->get_error();
			}else if ((in_array(1, $cid))  && ($publish==0)){
				$row->_error=sprintf(CANNOT_PUBLISH_ADMIN, MN_MEMBERS.' 1', MN_MEMBERS.' 1');
				$error=$row->get_error();
			}else{
				/*$cids=implode("','",$cid);
				$db->set_query("UPDATE `#__members` SET `active`='".$publish."' WHERE `id` IN ('".$cids."')");
				if(!$db->query())
				{
					$error=$db->stderr();
				}//end if*/
				$row->publish_array($cid, $publish);
			}//end if
		}//end if
		
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=members');
	}//end function

	function save(&$db)
	{
		$row=new members($db);
			
		$error=false;
		$ignore=null;

		if ($_POST["birthday"]) $_POST["birthday"] = db_date($_POST["birthday"]);
		
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check())$error=$row->get_error();
		if (!$row->id)
		{
			$row->password=md5(trim($row->password));
			$row->date_created=date("Y-m-d H:m:s");
		}else if(trim($row->password)!=""){
			$row->password=md5(trim($row->password));
		}else{
			$row->password=null;
		}//end if

		if ($row->code=='')
		{
			$row->code=$row->get_code();
		}//end if
		
		if(!$error)
			if (!$row->store())$error=$row->get_error();
		
		if ($error)
		{
			html_members::modify($row, $error);
		}else{
			redirect("?module=members");
		}//end if
	}//end function

	function remove(&$db, $cid)
	{	
		$row = new members($db);
		$error=false;

		if (count($cid))
		{
			if (in_array($_SESSION["member_id"], $cid))
			{
				$row->_error=sprintf(CANNOT_DELETE, MEMBER_ID.' '.$_SESSION["member_id"], MEMBER_ID.' '.$_SESSION["member_id"]);
				$error=$row->get_error();
			}else if (in_array(1, $cid)){
				$row->_error=sprintf(CANNOT_DELETE_ADMIN, MEMBER_ID.' 1', MEMBER_ID.' 1');
				$error=$row->get_error();
			}else{
				//$joins[]=array('label'=>MEMBER_ID, 'name'=>'`#__websites`', 'idfield'=>'id', 'joinfield'=>'`member_id`');
				$joins='';
				for($i=0; $i<count($cid); $i++)
				{
					if(!$row->can_delete($cid[$i], $joins))
					{
						$error[]=$row->get_error();
					}else{
						$row->delete_record($cid[$i]);
					}//end if
				}//end for
			}//end if
		}//end if
		
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=members');
	}//end function

	function group(&$db, $id)
	{
		if (!$id) return false;
		$row = new groups_member($db);
		$row->load($id);
		return $row;
	}//end function

	function website(&$db, $id)
	{
		$sql_sel="SELECT * FROM `#__websites` WHERE `member_id`=".$id." ORDER BY `website` ASC";
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		if (!$rows) return false;
		return $rows;
	}//end function

	function prifex_code($code, $prifex='')
	{
		if (!$code) return false;
		if ($prifex=='') return $code;
		return $prifex.$code;
	}//end function

	footer_page();
?>