// JavaScript Document
function trim(p_string) 
{
	if (typeof p_string != "string") return p_string;

	var t_string = p_string;
	var t_ch = '';

	// Trim beginning spaces
	t_ch = t_string.substring(0, 1);
	while (t_ch == " ") 
	{
		t_string = t_string.substring(1, t_string.length);
		t_ch = t_string.substring(0, 1);
	}//end while

	// Trim trailing spaces
	t_ch = t_string.substring(t_string.length-1, t_string.length);
	while (t_ch == " ") 
	{
		t_string = t_string.substring(0, t_string.length-1);
		t_ch = t_string.substring(t_string.length-1, t_string.length);
	}//end while

	return t_string;
}//end function

function get_cookies(p_cookie) 
{
	var t_cookie_name = "HB_" + p_cookie;
	var t_cookies = document.cookie;

	t_cookies = t_cookies.split(";");

	var i = 0;
	while(i < t_cookies.length) 
	{
		var t_cookie = t_cookies[i];

		t_cookie = t_cookie.split("=");
		if (trim(t_cookie[0]) == t_cookie_name) return (t_cookie[1]);
		i++;
	}//end while

	return -1;
}//end function

function set_cookie(p_cookie, p_value) 
{
	var t_cookie_name = "HB_" + p_cookie;
	var t_expires = new Date();

	t_expires.setTime(t_expires.getTime() + (365 * 24 * 60 * 60 * 1000));

	document.cookie = t_cookie_name + "=" + p_value + "; expires=" + t_expires + ";";
}//end function

var g_div_feature_areas	= 0x0001;
var g_div_tracking_areas= 0x0002;
var g_div_database_areas= 0x0004;
var g_div_system_areas	= 0x0008;

function get_view_settings() 
{
	var t_cookie = get_cookies("VIEW_SETTINGS");

	if (-1 == t_cookie) 
	{
		t_cookie = 0xffff;
	}else{
		t_cookie = parseInt(t_cookie);
	}//end if

	return t_cookie;
}//end function

function set_div(p_div, p_cookie_bit) 
{
	var t_view_settings = get_view_settings();

	if (t_view_settings & p_cookie_bit) 
	{
		document.getElementById( p_div + "_open" ).style.display = "none";
		//document.getElementById( p_div + "_closed" ).style.display = "block";
	}else{
		document.getElementById( p_div + "_open" ).style.display = "block";
		//document.getElementById( p_div + "_closed" ).style.display = "none";
	}//end if
}//end function

function toggle_div(p_div, p_cookie_bit) 
{
	var t_view_settings = get_view_settings();

	t_view_settings ^= p_cookie_bit;
	set_cookie("VIEW_SETTINGS", t_view_settings);

	set_div(p_div, p_cookie_bit);
}//end function