<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : administrator/includes/common.php
	# Description: This file's common use all the administration tool,
				   when you make a new feature, you need require the file 
				   on the top pages of feature.
	# Write by: Le Hung
	# Start time: September 17, 2007
	# Last update: 
	*/

	session_start();
	require_once ("../includes/dbconf.php");
	require_once ("../classes/database.php");
	require_once ("../classes/inputfilter.php");
	require_once ("../includes/globals.php");
	require_once ("../includes/functions.php");
	require_once ("./includes/functions.php");
	require_once ("./classes/draw_html.php");
	require_once ("../classes/language.php");
	require_once ("../classes/configuration.php");

	$db = new database(DB_SERVER, DB_SERVER_USERNAME, DB_SERVER_PASSWORD, DB_DATABASE, DB_PREFIX);
	$draw_html = new draw_html();

	$default=language_default($db);
	$language_info = trim(strtolower(get_param($_POST, 'language', $default["id"].'#'.$default["icon"] )));
	$language_id = language_info($language_info);
	$language_id = (!$language_id)?intval(get_param($_REGUEST, 'language_id', $default["id"])):$language_id;

	$ln = new language($db, $draw_html, $language_id);
	
	//config site
	$config = new configuration($db);
	$config ->load(1);
	//echo '<pre>';print_r($config);echo '</pre>';
	
	$show=intval(get_param($_GET, 'show', 0));
	if ($show) 
	{
		$language_id = $show;
		$language_info=$show.'#'.$ln->flag_icon($show);
	}//end if

	function language_default(&$db)
	{
		$sql_sel="SELECT * FROM `#__language` WHERE `active`=1 AND `default`=1";
		$db->set_query($sql_sel);
		$row=$db->load_record();

		if (!$row) return false;
		return $row;
	}//end function

	//Get information when user select language in the selectbox language
	function language_info($language, $flag="")
	{
		if (!$language) return false;
		list($language_id, $icon)=explode("#", $language);
		if ($flag) return $icon;
		return $language_id;
	}//end function

	function author_info(&$db, $table, $id)
	{
		$sql_sel="SELECT * FROM `".$table."` WHERE `id`=".$id;
		$db->set_query($sql_sel);
		$row=$db->load_record();
		//echo $db->get_query();
		//echo '<pre>';print_r($row);echo '</pre>';

		if (!$row) return false;
		return $row;
	}//end function

	function language_id(&$db, $folder)
	{
		$db->set_query('SELECT `id` FROM `#__language` WHERE `active`=1 AND `access_file`="'.$folder.'"');
		//echo $db->get_query();
		return $db->load_result();
	}//end function
?>