<?php	
	/* 
	# Copyright (C) 2007-2008 TQ Design Co., Ltd. All rights reserved.
	# Path to root: 
	# Description: 
	# Write by: Le Hung
	# Start time: 
	# Last update:  
	*/

	include_once("./logged.php");
	require_once("./classes/homes.php");
	require_once("../languages/".$_SESSION['folder']."/homes.php");
	require_once("./homes.html.php");
	require_once("./classes/tree.php");
	require_once("../includes/sajax.php");
	require_once("./includes/define.php");
	require_once("./classes/upload.php");
	
	$dir_path="../filesmanager/photos/";
	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$home_id = intval(get_param($_REQUEST, 'home_id', 0));
	$city = intval(get_param($_REQUEST, 'city', -1));
	$box_location=new tree($db, $language_id, '#__city', '#__city_convert', 'name', 'name_id');
	$box_type=new tree($db, $language_id, '#__type', '#__type_convert', 'type', 'type_id');
	
	$error=null;
	if (($action=='editconvert') && (!$id[0]))
	{
	 	$action='';
		$error= CONVERT_ERROR;
	}//end if

	sajax_init();
	eval(sajax_export('draw_district'));
	sajax_handle_client_request();
	
	header_page(MN_FEATURE_AREAS, MN_HOME_SEARCH.' :: '.MN_HOME_LIST);
	include_once ("./includes/editor/editor.php");

	switch ($action)
	{	
		case "publish":
			publish($db, $language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $language_id, $id, 0);
			break;

		case "new":
			modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;

		case "convert":
			if (!$home_id) $home_id=$id[0];
			convert($db, $home_id, 0);
			break;

		case "editconvert":
			convert($db, $home_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		case "district":
			district($db, $language_id,$city);
			break;
		
		default:
			show($db, $language_id, $error);
			break;
	}//end switch
	
	function show(&$db, $language_id, $error='')
	{
		global $default, $ln;
		
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$type_id = intval(get_param($_POST, 'type_id', 0));
		$occupied = get_param($_POST, 'occupied', '');
		$city_id = intval(get_param($_POST, 'city_id', 0));
		$district_id = intval(get_param($_POST, 'district_id', 0));

		$where = array();

		if (($ln->count_language()>1) && ($language_id!=$default["id"]))
		{
			$select='hc.*, h.`id` AS `id_default`, h.`type_id`, h.`occupied`, h.`city_id`, h.`district_id`, h.`area` AS `area_default`, h.`code`, h.`field_name1` AS `field_name1_default`, h.`field_value1` AS `field_value1_default`, h.`field_name2` AS `field_name2_default`, h.`field_value2` AS `field_value2_default`, h.`field_name3` AS `field_name3_default`, h.`field_value3` AS `field_value3_default`, h.`field_name4` AS `field_name4_default`, h.`field_value4` AS `field_value4_default`, h.`other_info` AS `other_info_default`, h.`price`, h.`address_code` AS `address_code_default`, h.`landlord` AS `landlord_default`, h.`address_contact` AS `address_contact_default`, h.`area`, h.`tel`, h.`fax`, h.`mobile`, h.`contact_person`, h.`image`, h.`create_by`, h.`modify_by`, h.`create_date`, h.`update_date`, h.`modify_date`, h.`active`';
			$from='`#__homes_convert` hc';
			$innerjoin='RIGHT JOIN `#__homes` h ON h.`id`=hc.`home_id` AND hc.`language_id`='.$language_id;
			if ($search) $where[] = '((LOWER(hc.`area`) LIKE "%'.$search.'%") OR (LOWER(h.`code`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_name1`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_name2`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_name3`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_name4`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_value1`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_value2`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_value3`) LIKE "%'.$search.'%") OR (LOWER(hc.`field_value4`) LIKE "%'.$search.'%") OR (LOWER(hc.`other_info`) LIKE "%'.$search.'%") OR (LOWER(h.`price`) LIKE "%'.$search.'%") OR (LOWER(hc.`address_code`) LIKE "%'.$search.'%") OR (LOWER(hc.`landlord`) LIKE "%'.$search.'%") OR (LOWER(hc.`address_contact`) LIKE "%'.$search.'%") OR (LOWER(h.`tel`) LIKE "%'.$search.'%") OR (LOWER(h.`fax`) LIKE "%'.$search.'%") OR (LOWER(h.`mobile`) LIKE "%'.$search.'%") OR (LOWER(h.`contact_person`) LIKE "%'.$search.'%"))';
			$sort='hc';
		}else{
			$select='h.*';
			$from='`#__homes` h';
			$innerjoin='';
			if ($search) $where[] = '((LOWER(h.`area`) LIKE "%'.$search.'%") OR (LOWER(h.`code`) LIKE "%'.$search.'%") OR (LOWER(h.`field_name1`) LIKE "%'.$search.'%") OR (LOWER(h.`field_name2`) LIKE "%'.$search.'%") OR (LOWER(h.`field_name3`) LIKE "%'.$search.'%") OR (LOWER(h.`field_name4`) LIKE "%'.$search.'%") OR (LOWER(h.`field_value1`) LIKE "%'.$search.'%") OR (LOWER(h.`field_value2`) LIKE "%'.$search.'%") OR (LOWER(h.`field_value3`) LIKE "%'.$search.'%") OR (LOWER(h.`field_value4`) LIKE "%'.$search.'%") OR (LOWER(h.`other_info`) LIKE "%'.$search.'%") OR (LOWER(h.`price`) LIKE "%'.$search.'%") OR (LOWER(h.`address_code`) LIKE "%'.$search.'%") OR (LOWER(h.`landlord`) LIKE "%'.$search.'%") OR (LOWER(h.`address_contact`) LIKE "%'.$search.'%") OR (LOWER(h.`tel`) LIKE "%'.$search.'%") OR (LOWER(h.`fax`) LIKE "%'.$search.'%") OR (LOWER(h.`mobile`) LIKE "%'.$search.'%") OR (LOWER(h.`contact_person`) LIKE "%'.$search.'%"))';
			$sort='h';
		}//end if

		if ($type_id) $where[] = 'h.`type_id`='.$type_id;
		if ($occupied) $where[] = "h.`occupied`='".$occupied."'";
		if ($city_id) $where[] = 'h.`city_id`='.$city_id;
		if ($district_id) $where[] = 'h.`district_id`='.$district_id;

		$sql_total=("SELECT count(*) AS num FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from." ".$innerjoin
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$sort.".".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		//echo '<pre>';print_r($rows);echo '</pre>';
		
		html_homes::show($language_id, $rows, $search, $_pav, $error, $type_id, $city_id, $district_id, $occupied);
	}//end function


function draw_occupied($attribs='', $selected='')
	{
		global $draw_html;
		$arr = array(
				$draw_html->make_option('', OCCUPIED),
				$draw_html->make_option('Yes', YES),
				$draw_html->make_option('No', NO)
				);
		return $draw_html->selectbox($arr, 'occupied', $attribs, 'value', 'text', $selected);
	}//end function
	
	
	function modify(&$db, $id)
	{
		$editor=new wysiwygPro();
		$row = new homes($db);
		$option_city="";
		if ($id)
		{
			$row->load($id);
			$option_city= $row->get_city();
		}else{
			$row->bind($_POST, ''); 
		}//end if
		
		html_homes::modify($row, $editor, $error, $option_city);
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id, $dir_path;
		$error=false;
		$row=($default["id"]==$language_id)?new homes($db):new homes_convert($db);

		$editor = new wysiwygPro();
		
		if ($default["id"]==$language_id)
		{
			//begin file attach
			$prefix=rand(0, 99999)."-";
			
			
			//add file attach
			$upload = new upload($_FILES["image"], $dir_path, $prefix, $_FILES["image"]["name"]);
			
			if (($_FILES["image"]["name"]) && ($_POST["old_file"]))
			{
				@unlink($dir_path.'source/'.$_POST["old_file"]);	
				@unlink($dir_path.'small/'.$_POST["old_file"]);
				@unlink($dir_path.'large/'.$_POST["old_file"]);
				$image=$_FILES["image"]["name"];
			}else if(($_FILES["image"]["name"]) && ($_POST["old_file"]=="")){
				$image=$_FILES["image"]["name"];
			}else{
				$_POST["image"]=$_POST["old_file"];
			}//end if

			if ($_FILES["image"]["name"])
			{
				if (!$upload->image()) 
				{
					$row->_error=PHOTO_FILE_NOTE;
					$error=$row->get_error();
				}else if (!$upload->file_size()){
					$row->_error=sprintf(CHECK_FILE_SIZE, intval(FILE_LIMIT/1048576));
					$error=$row->get_error();
				}else{
					if (!$upload->upload_resize_image(FILE_SMALL, FILE_LARGE, 'source'))
					{
						$row->_error=CHECK_SOURCE_DEST;
						$error=$row->get_error();
					}//end if
					$_POST["image"]=$prefix.strtolower($upload->clear_space($image));
				}//end if
			}//end if
			//end file attach
			if (isset($_POST['remove']) && ($_POST['remove']))
			{
				unlink($dir_path.$_POST["old_file"]);	
				$_POST["image"]='';
			}//end if
			$modify_date = date("Y-m-d H:m:s");
			
			if (!$_POST["id"]) 
			{
				$_POST["create_by"] = $_SESSION["member_id"];
				$_POST["create_date"]=$modify_date;
			}else{ 
				$_POST["modify_by"] = $_SESSION["member_id"];
				$_POST["modify_date"]=$modify_date;
			}//end if
		}else{
			$_POST["language_id"] = $language_id;
		}//end if
		$_POST["city_id"] = $_POST["city"]; 
		$_POST["district_id"] = $_POST["district"]; 
		
		
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		if (!$error)
		{
			if ($_POST['update_date']) $row->update_date=db_date($_POST['update_date']);
			if (!$row->store()) $error=$row->get_error();
		}//end if

		if ($error)
		{
			if ($default["id"]==$language_id)
			{
				html_homes::modify($row, $editor, $error);
			}else{
				$content_default=content_default($db, $row->home_id);
				$selected=$language_id.'#'.$ln->flag_icon($language_id);
				$flag=$ln->flag_icon($language_id);
					
				html_homes::convert($content_default, $selected, $flag, $row, $editor, $error, $editor);
			}//end if
		}else{
			$goto = trim(strtolower(get_param( $_POST, 'goto', '' )));
			switch ($goto)
			{
				case 'convert':
					redirect('./cpanel.php?module=homes&action=convert&content_id='.$row->id);
					break;
				
				case 'addmore':
					redirect('./cpanel.php?module=homes&action=new');
					break;
				
				default:
					if ($default["id"] == $language_id) redirect('./cpanel.php?module=homes');
					redirect('./cpanel.php?module=homes&show='.$row->language_id);	
					break;
			}//end switch
		}//end if
	}//end function
	
	function convert(&$db, $home_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$content_default=content_default($db, $home_id);
		$language_second = $ln->language_second();
		$selected=$language_second["id"].'#'.$language_second["icon"];
		$flag=$language_second["icon"];
		$row = new homes_convert($db);
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$content_default=content_default($db, $row->home_id);
		}//end if
			
		html_homes::convert($content_default, $selected, $flag, $row, $error, $editor);
	}//end function
	
	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new homes($db);
		$row->publish_array($cid, $publish);
		if ($default["id"] == $language_id) redirect('./cpanel.php?module=homes');
		redirect('./cpanel.php?module=homes&show='.$language_id);
	}//end function
	
	function remove(&$db, $language_id, $cid)
	{
		global $default, $dir_path;
		
		$row=($default["id"]==$language_id)?new homes($db):new homes_convert($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0; $i<count($cid); $i++)
			{
				if ($default["id"]==$language_id)
				{
					$home_photos=$row->delete_home_photos($cid[$i]);
					if ($home_photos)
					{
						foreach ($home_photos as $photos)
						{
							@unlink($dir_path.'source/'.$photos['image']);	
							@unlink($dir_path.'small/'.$photos['image']);
							@unlink($dir_path.'large/'.$photos['image']);	
						}//end foreach 
						$db->set_query("DELETE FROM `#__home_photos` WHERE `home_id`=".$cid[$i]);
						$db->query();
					}//end if
					$file = $row->delete_file($cid[$i]);
					@unlink($dir_path.'source/'.$file);	
					@unlink($dir_path.'small/'.$file);
					@unlink($dir_path.'large/'.$file);
				
					$db->set_query("DELETE FROM `#__homes_convert` WHERE `home_id`=".$cid[$i]);
					$db->query();
				}//end if
				$row->delete_record($cid[$i]);
			}//end for
		}//end if


		if ($default["id"]==$language_id) redirect('./cpanel.php?module=homes');
		redirect('./cpanel.php?module=homes&show='.$language_id);
	}//end function

	function draw_district($city_id)
	{
		global $box_location;
		return $box_location->draw_popup('district_id', false, '', 'class="selectbox" size="1" id="district_id"', SELECT_DISTRICT, '', ' AND `parent_id`='.$city_id);
	}//end function
	
	function content_default(&$db, $id)
	{
		if (!$id) return false;
		$row = new homes($db);
		$row->load($id);
		return $row;
	}//end function
	
	
	/*function district(&$db, $language_id, $city_id)
	{
		global $default, $ln;
		
	
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`id`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";
		$district_id = intval(get_param($_REQUEST, 'districtid', -1));
		$where = array();

			$select='c.*';
			$from='`#__city` c';
		
		$where = ' AND h.`parentid_id`='.$city_id;

		$sql_sel=("SELECT ".$select." FROM ".$from." WHERE active =1 ".$where; 
		$db->set_query($sql_sel);
		//echo $db->get_query();
		
		$rows=$db->load_record_list();
		
		$jsout= "<select size=1 id=\"district\" name=\"district\" class='select'  >";
		$jsout.="<option value=\"0\">-- SELECT DISTRICT --</option>";
		for($i=0;$i<count($rows);$i++){
			if ($row['id']==$district_id)
				$jsout.="<option value=\"".$rows[$i]['id']."\" selected>".$rows[$i]['name']."</option>";
			else
				$jsout.="<option value=\"".$rows[$i]['id']."\">".$rows[$i]['name']."</option>";
		}
		$jsout.="</select>";
		return $jsout;
	}//end function*/
	footer_page();
?>