<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/news.php 
	# Description: This file's the access to module content.
	# Write by: Le Hung
	# Start time: December 27, 2007
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/faqs.php");
	require_once("../languages/".$_SESSION['folder']."/faqs.php");
	require_once("./faqs.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	if (($action=='') || ($action=='cancel')) $action='answered';
	header_page(MN_FEATURE_AREAS, MN_FAQS);
	include_once ("./includes/editor/editor.php");

	//print_r($_SESSION);

	switch ($action)
	{	
		case "publish":
			publish($db,$language_id, $id, 1);
			break;
		
		case "unpublish":
			publish($db,$language_id, $id, 0);
			break;

		case "new":
			modify($db, $language_id, 0);
			break;
		
		case "edit":
			modify($db, $language_id, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $language_id, $id);
			break;
		
		default:
			show($db, $language_id);
			break;
	}//end switch

	function show(&$db, $language_id)
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`maked_date`')));
		if (!$field_sort) $field_sort="`maked_date`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'DESC'));
		if (!$sort_by) $sort_by="DESC";

		$where = array();
		
		$select='f.id, f.`content` as question, f.`maked_by` as question_by, f.`maked_date` as question_date, f.`phone` as question_phone, f.`email` as question_email, `active`';
		$from='`#__faqs` f';
		if ($search) $where[] = 'LOWER(f.`content`) LIKE "%'.$search.'%" OR LOWER(f.`maked_by`) LIKE "%'.$search.'%"';

		$where[]='(`question_id`=0 OR `question_id`=null)';
		$where[]="`language_id`=".$language_id;
		
		$sql_total=("SELECT count(*) AS num FROM ".$from
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT ".$select." FROM ".$from
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		if ($rows)
		{
			foreach ($rows as $k=>$v)
			{
				$sql_sel=('SELECT `content` as answer, `maked_by` as answer_by, `maked_date` as answer_date, `phone` as answer_phone, `email` as answer_email FROM `#__faqs` WHERE `question_id`='.$v['id']);
				
				$db->set_query($sql_sel);
				//echo $db->get_query();
				$rows[$k]['answer']=$db->load_record();
			}//end foreach
		}//end if
		//echo '<pre>';print_r($rows);echo '</pre>';
		
		html_faqs::show($rows, $search, $_pav);
	}//end function

	function modify(&$db, $language_id, $id)
	{
		global $ln;
		$editor=new wysiwygPro();
		$editor2=new wysiwygPro();
		$row = new faqs($db);
		$row2 = new faqs($db);
		$selected=$language_id.'#'.$ln->flag_icon($language_id);
		$flag=$ln->flag_icon($language_id);
		
		if ($id)
		{
			$row->load($id);
			$selected=$row->language_id.'#'.$ln->flag_icon($row->language_id);
			$flag=$ln->flag_icon($row->language_id);
			$answer_id=answer_id($db, $id);
			$row2->load($answer_id);
		}//end if
			
		html_faqs::modify($row, $row2, $selected, $flag, $editor, $editor2, $error);
	}//end function

	function publish(&$db, $language_id, $cid=null, $publish=1)
	{
		global $default;
		$row = new faqs($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=faqs');
	}//end function

	function save(&$db)
	{
		global $default, $ln, $language_id;
		$error=false;
		$row = new faqs($db);
		$row2 = new faqs($db);

		$editor = new wysiwygPro();
		$editor2 = new wysiwygPro();
		
		if ($_POST['maked_date']) $_POST['maked_date']=db_date($_POST['maked_date']);
		else $_POST['maked_date']= date("Y-m-d");
		$_POST["language_id"] = $language_id;
		$ignore=null;
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check()) $error=$row->get_error();
		
		if (!$error)
		{
			if ($_POST['id']) $row->active=1;
			if (!$row->store()) 
			{
				$error=$row->get_error();
			}else{
				$author_info=author_info($db, '#__members', $_SESSION['member_id']);
				
				if($_POST['id']){
					$sql = "UPDATE `#__faqs` SET `question_id`='".$row->id."',`content`='".$_POST['content2']."',`maked_by`='".$author_info['fullname']."',`phone`='".$author_info['phone']."',`email`='".$author_info['email']."', `language_id`='".$language_id."'  WHERE id='".$_POST['answer_id']."'";
				}else{
					$question_id = get_question_id($db);
					$sql ="INSERT INTO `#__faqs`(`question_id`, `content`, `maked_by`, `phone`, `email`, `language_id`) VALUES ('".$question_id."','".$_POST['content2']."','".$author_info['fullname']."', '".$author_info['phone']."', '".$author_info['email']."', '".$language_id."')";
				} 
				//echo $sql; 
				$db->set_query($sql);
				$db->query();	
			}//end if
		}//end if

		if ($error)
		{
			html_faqs::modify($row, $row2, $editor, $editor2, $error);
		}else{
			redirect('./cpanel.php?module=faqs&show='.$language_id);
		}//end if
	}//end function

	function remove(&$db,$language_id, $cid)
	{	
		$row = new faqs($db);
		$error=array();

		$joins='';
		if (count($cid))
		{
			for($i=0;$i<count($cid);$i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$answer_id=answer_id($db, $cid[$i]);
					$row->delete_record($answer_id);
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		redirect('./cpanel.php?module=faqs');
	}//end function

	function answer_id(&$db, $id)
	{
		$db->set_query('SELECT `id` FROM `#__faqs` WHERE `question_id`='.$id);
		return $db->load_result();
	}//end function
	function get_question_id(&$db)
	{
		$db->set_query('SELECT `id` FROM `#__faqs` ORDER BY `id` DESC LIMIT 0,1');
		return $db->load_result();
	}//end function
	footer_page();
?>