<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root: administrator/customers.php 
	# Description: This file's the access to module members.
	# Write by: Le Hung
	# Start time: 
	# Last update: 
	*/

	include_once("./logged.php");
	require_once("./classes/customers.php");
	require_once("./classes/tree.php");
	require_once("../languages/".$_SESSION['folder']."/customers.php");
	require_once("./customers.html.php");

	$action=trim(strtolower(get_param($_REQUEST, 'action', '' )));
	$box_location = new tree($db, $language_id, '#__locations', '', 'name', '');
	$no_convert = true;

	header_page(MN_TRACKING_AREAS, MN_CUSTOMERS);

	switch ($action)
	{	
		case "publish":
			publish($db, $id, 1);
			break;
		
		case "unpublish":
			publish($db, $id, 0);
			break;

		case "new":
				modify($db, 0);
			break;
		
		case "edit":
			modify($db, $id[0]);
			break;
				
		case "save":
			save($db);
			break;
		
		case "remove":
			remove($db, $id);
			break;
		
		default:
			show($db);
			break;
	}//end switch

	function show(&$db, $error="")
	{	
		$search = trim(strtolower(get_param( $_POST, 'search', '' )));
		$limit = intval(get_param($_POST, 'limit', 20));
		$limitstart = intval(get_param($_POST, 'limitstart', 0));
		$field_sort=trim(strtolower(get_param( $_POST, 'field_sort', '`customer`')));
		if (!$field_sort) $field_sort="`id`";
		$sort_by=trim(get_param( $_POST, 'sort_by', 'ASC'));
		if (!$sort_by) $sort_by="ASC";

		$country_id=intval(get_param($_POST, 'country_id', 0));

		$where = array();

		if ($search) 
		{
			$where[] = '(LOWER(`username`) LIKE "%'.$search.'%" OR LOWER(`email`) LIKE "%'.$search.'%" OR LOWER(`customer`) LIKE "%'.$search.'%" OR LOWER(`company`) LIKE "%'.$search.'%" OR LOWER(`address`) LIKE "%'.$search.'%" OR LOWER(`address2`) LIKE "%'.$search.'%" OR LOWER(`tel_work`) LIKE "%'.$search.'%" OR LOWER(`tel_home`) LIKE "%'.$search.'%" OR LOWER(`mobile`) LIKE "%'.$search.'%" OR LOWER(`note`) LIKE "%'.$search.'%")';
		}//end if

		if ($country_id) $where[] = '`country_id`='.$country_id;
		

		$sql_total=("SELECT count(*) AS num FROM `#__customers` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : ""));
		$db->set_query($sql_total);
		$total=$db->load_result();

		include_once( "./classes/pages.php");
		$_pav = new pages($total, $limitstart, $limit);

		$sql_sel=("SELECT * FROM `#__customers` "
				. (count( $where ) ? "\nWHERE " . implode( ' AND ', $where ) : "")
				. "\n ORDER BY ".$field_sort." ".$sort_by
				. "\nLIMIT ".$_pav->limitstart.", ".$_pav->limit);
		$db->set_query($sql_sel);
		//echo $db->get_query();
		$rows=$db->load_record_list();
		
		html_customers::show($rows, $search, $_pav, $country_id, $error);
	}//end function

	function modify(&$db, $id)
	{
		$row = new customers($db);
		if ($id)
		{
			$row->load($id);
		}else{
			$row->bind($_POST, '');
		}//end if

		html_customers::modify($row, $error);
	}//end function

	function publish(&$db, $cid=null, $publish=1)
	{
		$row = new customers($db);
		$row->publish_array($cid, $publish);
		redirect('./cpanel.php?module=customers');
	}//end function

	function save(&$db)
	{
		$row=new customers($db);
			
		$error=false;
		$ignore=null;

		$modify_date = date("Y-m-d H:m:s");		
		if (!$row->bind($_POST, $ignore)) $error=$row->get_error(); 
		if (!$row->check())$error=$row->get_error();
		if (!isset($_POST['move_management']) || (!$_POST['move_management'])) $row->move_management=0;
		if (!isset($_POST['relocation']) || (!$_POST['relocation'])) $row->relocation=0;
		if (!isset($_POST['record_management']) || (!$_POST['record_management'])) $row->record_management=0;
		if (!isset($_POST['move_in']) || (!$_POST['move_in'])) $row->move_in=0;
		if (!isset($_POST['move_in_air']) || (!$_POST['move_in_air'])) $row->move_in_air=0;
		
		if (!isset($_POST['move_out']) || (!$_POST['move_out'])) $row->move_out=0;
		if (!isset($_POST['move_out_air']) || (!$_POST['move_out_air'])) $row->move_out_air=0;
		
		//delete_inbound($db, $_POST['id'], $row->move_in);
		//delete_outbound($db, $_POST['id'], $row->move_out);
		
		if (!$row->id)
		{
			$row->password=trim($row->password);
			$row->create_by = $_SESSION["member_id"];
			$row->create_date=$modify_date;
		}else if(trim($row->password)!=""){
			$row->password=trim($row->password);
			$row->modify_by = $_SESSION["member_id"];
			$row->modify_date=$modify_date;
		}else{
			$row->password=null;
		}//end if
		
		if(!$error)
			if (!$row->store())$error=$row->get_error();
		
		if ($error)
		{
			html_customers::modify($row, $error);
		}else{
			redirect("?module=customers");
		}//end if
	}//end function

	function remove(&$db, $cid)
	{	
		$row = new customers($db);
		$error=false;

		if (count($cid))
		{
			$joins='';
			for($i=0; $i<count($cid); $i++)
			{
				if(!$row->can_delete($cid[$i], $joins))
				{
					$error[]=$row->get_error();
				}else{
					$row->delete_record($cid[$i]);
				}//end if
			}//end for
		}//end if
		
		if ($error) show($db, $error);
		else redirect('./cpanel.php?module=customers');
	}//end function

	function country(&$db, $id)
	{
		$db->set_query('SELECT `name` FROM `#__locations` WHERE `id`='.$id);
		return $db->load_result();
	}//end function

	function delete_inbound(&$db, $id, $new_service)
	{
		$db->set_query('SELECT `move_in` FROM `#__customers` WHERE `id`='.$id);
		$old_service=$db->load_result();

		if (($old_service) && ($old_service!=$new_service))
		{
			if ($old_service==1) $db->set_query('DELETE FROM `#__inbound` WHERE `customer_id`='.$id);
			
			return $db->query();
		}//end if
	}//end if
	function delete_outbound(&$db, $id, $new_service)
	{
		$db->set_query('SELECT `move_out` FROM `#__customers` WHERE `id`='.$id);
		$old_service=$db->load_result();

		if (($old_service) && ($old_service!=$new_service))
		{
			if ($old_service==1) $db->set_query('DELETE FROM `#__outbound` WHERE `customer_id`='.$id);
			return $db->query();
		}//end if
	}//end if

	footer_page();
?>