<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : classes/signin.php
	# Description: The signin class is meant to simplify the task of keeping
				   track of logged in users and also guests.
	# Write by: Le Hung
	# Start time: September 18, 2007
	# Last update: November 13, 2007
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');
	class signin
	{
		//var $ip		  = null;	//IP's sign in to administration tool	
		var $username = null;	//Username given on sign-up
		var $password = null;	//Password given on sign-up
		var $remember = null;	//Remember signin, don't need input 
								//username and password at next time
		var $_db	= null;			//The database connection
		var $online = null;		//Get information of user online
		
		function signin(&$db, &$online, $username, $password, $remember)
		{
			$this->_db = &$db;
			$this->online = &$online;
			$this->username = $username;
			$this->password = $password;
			$this->remember = $remember;
		}//end function

		//check_signin - Checking the username, password
		function submit_signin()
		{

			$this->_db->set_query("SELECT m.* FROM `#__members` m INNER JOIN `#__groups_member` g ON m.`group_id`=g.`id` WHERE m.`username`='".$this->username."' AND m.`password`='".$this->password."' AND m.`active`=1");
			
			if ($this->_db->load_object($this))
			{
				$this->remove_ip_denied();
				$this->update_cooked();
				$this->session();
				$this->update_signin_time();
				$this->remember();
				return true;
			}//end if
			return false;
		}//end function
		
		/*remeber - When checkbox remember me next time is checked, we need 
		set cookie for member sign in*/
		function remember()
		{
			if ($this->remember) 
			{
				setcookie("cookname", $_SESSION["username"], time()+intval(COOKIE_EXPIRE), COOKIE_PATH);
				setcookie("cooked", $_SESSION["cooked"], time()+intval(COOKIE_EXPIRE), COOKIE_PATH);
			}//end if	
		}//end function

		/*session - Set session some more infomation of user sigin, we'll using 
		it when member working on administration tool*/
		function session()
		{
			$userinfo=$this->online->get_user_info($this->username);
			if ($userinfo)
			{
				$_SESSION["member_id"]=$userinfo["id"];
				$_SESSION["group_member_id"]=$userinfo["group_id"];
				$_SESSION["fullname"]=$userinfo["fullname"];
				$_SESSION["username"]=$userinfo["username"];
				$_SESSION["password"]=$userinfo["password"];
				$_SESSION["last_visit"]=$userinfo["last_visit"];
				$_SESSION["cooked"]=$userinfo["cooked"];
			}//end function
		}//end function

		/*add_ip_denied - Add ip to table signin_denied when user sigin try submit with 3 
		failed*/
		function add_ip_denied()
		{		
			$this->_db->set_query("INSERT INTO `#__signin_denied`(`ip`, `timestamp`) VALUES('".$_SERVER['REMOTE_ADDR']."', ".time().")");
			$this->_db->query();
			//echo $this->_db->get_query();
			//exit();
		}//end function

		//remove_ip_denied - When the user sign in well, remove ip from table signin_denied
		function remove_ip_denied()
		{
			$this->_db->set_query("DELETE FROM `#__signin_denied` WHERE `ip` = '".$_SERVER['REMOTE_ADDR']."'");
			$this->_db->query();
			//echo $this->_db->get_query();
			//exit();
		}//end function

		//update_cooked - When user sigin well, we need updating user's cooked
		function update_cooked()
		{
			$cooked=$this->generate_rand_id();
			$this->_db->set_query("UPDATE `#__members` SET `cooked`='".$cooked."' WHERE `username`='".$this->username."'");
			$this->_db->query();
		}//end function

		//update_signin_time - When user sign in well, wee nedd updating user's date visit.
		function update_signin_time()
		{
			$sql_sel="SELECT `date_visit` FROM `#__members` WHERE `id`=".$_SESSION["member_id"];
			$this->_db->set_query($sql_sel);
			$last_visit = $this->_db->load_result();
			$date_visit = date("Y-m-d H:m:s");

			$sql_update="UPDATE `#__members` SET `last_visit`='".$last_visit."', `date_visit`='".$date_visit."' WHERE `id`=".$_SESSION["member_id"];
			$this->_db->set_query($sql_update);
			$this->_db->query();
		}//end function

		/*generate_rand_id - Generates a string made up of randomized letters (lower and upper case) 
		and digits and returns the md5 hash of it to be used as a cooked.*/
		function generate_rand_id()
		{
			return md5($this->generate_rand_string(16));
		}//end function

		/*generate_rand_string - Generates a string made up of randomized letters (lower and upper case) 
		and digits, the length is a specified parameter.*/
		function generate_rand_string($length)
		{
			$randstr = "";
			for ($i=0; $i<$length; $i++)
			{
				$randnum = mt_rand(0, 61);
				if ($randnum < 10)
				{
					$randstr .= chr($randnum + 48);
				}else if ($randnum < 36){
					$randstr .= chr($randnum+55);
				}else{
					$randstr .= chr($randnum+61);
				}//end if
			}//and for
			return $randstr;
		}//end function
		
		
	}//end class
?>