<?php
	/* 
	# Copyright (C) 2007 TQ Design Co., Ltd. All rights reserved.
	# Path to root : classes/online.php
	# Description: The signin class is meant to simplify the task of keeping
				   track of logged in users and also guests.
	# Write by: Le Hung
	# Start time: Septrmber 18, 2007
	# Last update: November 13, 2007
	*/

	defined ('_SITE_START') or die('Direct Access to this location is not allowed.');
	class online
	{
		var $username;			//Username given on sign-up
		var $cooked;			//Random value generated on current login
		var $time;				//Time user was last active (page loaded)
		var $logged;			//True if user is logged in, false otherwise
		var $userinfo = array();//The array holding all user info
		var $url;				//The page url current being viewed
		var $referrer;			//Last recorded site page viewed
		var $m_online;			//The number of user on page viewed
		var $g_inline;			//The number of guest on page viewed
		var $_db = null;				//The database connection
		/**
		* Note: referrer should really only be considered the actual
		* page referrer in administration control , any other time it may be
		* inaccurate.
		*/
		function online(&$db)
		{
			$this->time = time();
			$this->_db = &$db;
			$this->start_session();
		}//end function

		/*start_session - Performs all the actions necessary to initialize 
		this session object. Tries to determine if the the user has logged 
		in already, and sets the variables accordingly. Also takes advantage 
		of this page load to update the active visitors tables.
		*/
		function start_session()
		{
			//Determine if user is logged in 
			$this->logged = $this->check_signin();

			/*Set guest value to users not logged in, and update active 
			guests table accordingly.*/
			if (!$this->logged)
			{
				$this->add_guest_online($_SERVER['REMOTE_ADDR'], $this->time);
			}else{
				$this->add_member_online($this->username, $this->time);
			}//end if

			//Remove inactive visitors from database 
			$this->remove_members_inactive();
			$this->remove_guests_inactive();

			//Set referrer page
			if (isset($_SESSION['url'])) $this->referrer = $_SESSION['url'];
			else $this->referrer = "/";

			///Set current url
			$this->url = $_SESSION['url'] = $_SERVER['PHP_SELF'];
		}//end function

		/*check_denied - When user go to and access form sign in, if last time, user sign in 3
		failed, user can't access to form signin with TIME_DENIED*/
		function check_denied()
		{
			$this->_db->set_query("SELECT `ip`"
							  ."\n FROM `#__signin_denied`"
							  ."\n WHERE `ip`='".$_SERVER['REMOTE_ADDR']."'");
			if ($this->_db->load_result())
			{
				$this->_db->set_query("SELECT `ip`"
								  ."\n FROM `#__signin_denied`"
								  ."\n WHERE `ip`='".$_SERVER['REMOTE_ADDR']."'"
								  ."\n AND (DATE_ADD(FROM_UNIXTIME(`timestamp`), INTERVAL ".intval(TIME_DENIED/3600)." HOUR) > NOW())");
				//echo $this->_db->get_query();
				//exit();
				if ($this->_db->load_result()) redirect("./denied.php");
				return true;
			}//end if
			return true;
		}//end function

		/*check_signin - Checks if the user has already previously logged in, 
		and a session with the user has already been established. Also checks 
		to see if user has been remembered. If so, the database is queried 
		to make sure of the user's authenticity. Returns true if the user has 
		logged in.*/
		function check_signin()
		{
			//Check if user has been remembered
			if (isset($_COOKIE['cookname']) && isset($_COOKIE['cooked']))
			{
				$this->username = $_SESSION['username'] = $_COOKIE['cookname'];
				$this->cooked   = $_SESSION['cooked']   = $_COOKIE['cooked'];
			}//end if

			//Username and cooked have been set and not guest
			if (isset($_SESSION['username']) && isset($_SESSION['cooked']))
			{
				//echo "asdasd: ".$this->confirm_user($_SESSION['username'], $_SESSION['cooked']);
				//Confirm that username and cooked are valid
				if ($this->confirm_user($_SESSION['username'], $_SESSION['cooked']) != 0)
				{
					//Variables are incorrect, user not logged in
					unset($_SESSION['username']);
					unset($_SESSION['cooked']);
					return false;
				}//end if
				
				//User is logged in, set class variables
				$this->userinfo  = $this->get_user_info($_SESSION['username']);
				$this->username  = $this->userinfo['username'];
				$this->cooked    = $this->userinfo['cooked'];
				return true;
				
			}else{//User not logged in
				return false;
			}//end if
		}//end function

		//add_guest_online - Adds guest to active guests table
		function add_guest_online($ip, $time)
		{
			if (!TRACK_VISITORS) return;

			$sql_replace = "REPLACE INTO `#__guests_online` VALUES ('".$ip."', ".$time.")";
			$this->_db->set_query($sql_replace);
			$this->_db->query();
		}//end function

		/*add_member_online - Updates username's last active timestamp in the database, 
		and also adds him to the table of active users, or updates timestamp if already there.*/
		function add_member_online($username, $time)
		{
			$sql_update = "UPDATE `#__members_online` SET `timestamp` = ".$time." WHERE `username` = '".$username."'";
			$this->_db->set_query($sql_update);
			$this->_db->query();

			if (!TRACK_VISITORS) return;

			$sql_replace = "REPLACE INTO `#__members_online` VALUES ('".$username."', ".$time.")";
			$this->_db->set_query($sql_replace);
			$this->_db->query();
			$this->members_online();
		}//end function

		//remove_members_inactive - Clean user when time out
		function remove_members_inactive()
		{
			if (!TRACK_VISITORS) return;

			$timeout = time()-intval(USER_TIMEOUT * 60);
			$sel_del = ("DELETE FROM `#__members_online` WHERE `timestamp` < ".$timeout);
			$this->_db->set_query($sel_del);
			$this->_db->query();
			$this->members_online();
		}//end function

		//remove_guests_inactive - Clean guest when time out
		function remove_guests_inactive()
		{
			if (!TRACK_VISITORS) return;

			$timeout = time()-intval(GUEST_TIMEOUT * 60);
			$sql_del = ("DELETE FROM `#__guests_online` WHERE `timestamp` < ".$timeout);
			$this->_db->set_query($sql_del);
			$this->_db->query();
			$this->guests_online();
		}//end function

		/*members_online - Finds out how many active users are viewing 
		site and sets class variable accordingly.*/
		function members_online()
		{
			//Calculate number of users at site
			$sql_sel = "SELECT COUNT(*) AS num FROM `#__members_online`";
			$this->_db->set_query($sql_sel);
			$this->m_online = $this->_db->load_result();
		}//end function

		/*guests_online - Finds out how many active guest are viewing 
		site and sets class variable accordingly.*/
		function guests_online()
		{
			//Calculate number of guests at site
			$sql_sel = "SELECT COUNT(*) AS num FROM `#__guests_online`";
			$this->_db->set_query($sql_sel);
			$this->g_online = $this->_db->load_result();
		}//end function

		/*confirm_user - Checks whether or not the given username is in the database, 
		if so it checks if the given cooked is the same cooked in the database for 
		that user. If the user doesn't exist or if the cooked don't match up, 
		it returns an error code (1 or 2). On success it returns 0.*/
		function confirm_user($username, $cooked)
		{
			//Add slashes if necessary (for query)
			if (!get_magic_quotes_gpc()) $username = addslashes($username);

			//Verify that user is in database
			$sql_sel = "SELECT `cooked` FROM `#__members` WHERE `username` = '".$username."'";
			$this->_db->set_query($sql_sel);
			
			$value=$this->_db->query();
			$result=$this->_db->load_result();

			if (!$result || ($this->_db->get_num_rows($value) < 1)) 
			{
				return 1; //Indicates username failure
			}//end if

			//echo "<br>".$this->_db->get_num_rows($value);
			//echo "<br>".$this->_db->get_query();
			//echo "<br>".$result;
			//echo "<br>".$cooked;
			
			//Retrieve cooked from result, strip slashes
			$result = stripslashes($result);
			$cooked = stripslashes($cooked);
			

			//Validate that cooked is correct
			if ($cooked == $result) return 0; //Success! Username and cooked confirmed
			else return 2; //Indicates cooked invalid
		}//end function

		//get_user_info - Get user information the given username is in the database
		function get_user_info($username)
		{
			$sql_sel="SELECT * FROM `#__members` WHERE `username`='".$username."'";
			$this->_db->set_query($sql_sel);
			$result=$this->_db->load_record();

			if (!$result) return false;
			return $result;
		}//end function 
		
	}//end class
?>